/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.spi;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.link.markup.DummyLinkMarkupBuilder;
import io.wcm.handler.link.markup.SimpleLinkMarkupBuilder;
import io.wcm.handler.link.processor.DefaultInternalLinkInheritUrlParamLinkPostProcessor;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.ExternalLinkType;
import io.wcm.handler.link.type.InternalLinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.sling.commons.caservice.ContextAwareService;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class LinkHandlerConfig
implements ContextAwareService {
    private static final List<Class<? extends LinkType>> DEFAULT_LINK_TYPES = ImmutableList.of(InternalLinkType.class, ExternalLinkType.class, MediaLinkType.class);
    private static final List<Class<? extends LinkMarkupBuilder>> DEFAULT_LINK_MARKUP_BUILDERS = ImmutableList.of(SimpleLinkMarkupBuilder.class, DummyLinkMarkupBuilder.class);
    private static final List<Class<? extends LinkProcessor>> DEFAULT_POST_PROCESSORS = ImmutableList.of(DefaultInternalLinkInheritUrlParamLinkPostProcessor.class);
    private static final String REDIRECT_RESOURCE_TYPE = "wcm-io/handler/link/components/page/redirect";

    public List<Class<? extends LinkType>> getLinkTypes() {
        return DEFAULT_LINK_TYPES;
    }

    public List<Class<? extends LinkMarkupBuilder>> getMarkupBuilders() {
        return DEFAULT_LINK_MARKUP_BUILDERS;
    }

    public List<Class<? extends LinkProcessor>> getPreProcessors() {
        return ImmutableList.of();
    }

    public List<Class<? extends LinkProcessor>> getPostProcessors() {
        return DEFAULT_POST_PROCESSORS;
    }

    public boolean isValidLinkTarget(Page page) {
        return true;
    }

    public boolean isRedirect(Page page) {
        Resource pageContent = page.getContentResource();
        ResourceResolver resolver = pageContent.getResourceResolver();
        return resolver.isResourceType(pageContent, REDIRECT_RESOURCE_TYPE);
    }
}

