/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkType;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class ExternalLinkType
extends LinkType {
    public static final String ID = "external";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getPrimaryLinkRefProperty() {
        return "linkExternalRef";
    }

    @Override
    public boolean accepts(String linkRef) {
        return StringUtils.contains((CharSequence)linkRef, (CharSequence)"://") || StringUtils.startsWith((CharSequence)linkRef, (CharSequence)"mailto:");
    }

    @Override
    public Link resolveLink(Link link) {
        ValueMap props = link.getLinkRequest().getResourceProperties();
        String linkUrl = (String)props.get("linkExternalRef", String.class);
        if (StringUtils.isBlank((CharSequence)linkUrl)) {
            linkUrl = null;
        }
        link.setUrl(linkUrl);
        return link;
    }

    public static Resource getSyntheticLinkResource(ResourceResolver resourceResolver, String url) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkType", ID);
        map.put("linkExternalRef", url);
        return new SyntheticLinkResource(resourceResolver, map);
    }

    public String toString() {
        return ID;
    }
}

