/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.handler.link.type.helpers.InternalLinkResolver;
import io.wcm.handler.link.type.helpers.InternalLinkResolverOptions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class InternalLinkType
extends LinkType {
    public static final String ID = "internal";
    private final InternalLinkResolverOptions resolverOptions = new InternalLinkResolverOptions().primaryLinkRefProperty(this.getPrimaryLinkRefProperty()).rewritePathToContext(true).useTargetContext(false);
    @Self
    private InternalLinkResolver internalLinkResolver;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getPrimaryLinkRefProperty() {
        return "linkContentRef";
    }

    @Override
    public boolean accepts(String linkRef) {
        return StringUtils.startsWith((CharSequence)linkRef, (CharSequence)"/content/") && !MediaLinkType.isDefaultMediaContentPath(linkRef);
    }

    @Override
    public boolean accepts(LinkRequest linkRequest) {
        if (this.internalLinkResolver.acceptPage(linkRequest.getPage(), this.resolverOptions)) {
            return true;
        }
        return super.accepts(linkRequest);
    }

    @Override
    public Link resolveLink(Link link) {
        return this.internalLinkResolver.resolveLink(link, this.resolverOptions);
    }

    public static Resource getSyntheticLinkResource(ResourceResolver resourceResolver, String pageRef) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkType", ID);
        map.put("linkContentRef", pageRef);
        return new SyntheticLinkResource(resourceResolver, map);
    }

    public String toString() {
        return ID;
    }
}

