/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type.helpers;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkArgs;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.type.helpers.InternalLinkResolverOptions;
import io.wcm.handler.link.type.helpers.LinkResolveCounter;
import io.wcm.handler.link.type.helpers.SyntheticNavigatableResource;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.spi.UrlHandlerConfig;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.util.RunMode;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class InternalLinkResolver {
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @Self
    private UrlHandlerConfig urlHandlerConfig;
    @Self
    private LinkHandler linkHandler;
    @Self
    private UrlHandler urlHandler;
    @SlingObject
    private ResourceResolver resourceResolver;
    @AemObject
    private PageManager pageManager;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private WCMMode wcmMode;
    @OSGiService
    private SlingSettingsService slingSettings;

    public boolean acceptPage(Page page, InternalLinkResolverOptions options) {
        if (page == null) {
            return false;
        }
        if (!page.hasContent()) {
            return false;
        }
        if (RunMode.isPublish((Set)this.slingSettings.getRunModes()) && !page.isValid()) {
            return false;
        }
        return this.linkHandlerConfig.isValidLinkTarget(page);
    }

    public Link resolveLink(Link link, InternalLinkResolverOptions options) {
        LinkRequest linkRequest = link.getLinkRequest();
        ValueMap props = linkRequest.getResourceProperties();
        boolean referenceSet = false;
        Page targetPage = link.getLinkRequest().getPage();
        if (targetPage != null) {
            referenceSet = true;
        }
        if (targetPage == null) {
            String targetPath = (String)props.get(options.getPrimaryLinkRefProperty(), String.class);
            if (StringUtils.isNotEmpty((CharSequence)targetPath)) {
                referenceSet = true;
            }
            targetPage = this.getTargetPage(targetPath, options);
        }
        UrlHandlerConfig resolvingUrlHandlerConfig = this.urlHandlerConfig;
        UrlHandler resolvingUrlHandler = this.urlHandler;
        if (targetPage != null && options.isUseTargetContext() && !options.isRewritePathToContext()) {
            Resource resource = targetPage.getContentResource();
            resolvingUrlHandlerConfig = (UrlHandlerConfig)AdaptTo.notNull((Adaptable)resource, UrlHandlerConfig.class);
            resolvingUrlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)resource, UrlHandler.class);
        }
        if (targetPage != null && (this.linkHandlerConfig.isRedirect(targetPage) || resolvingUrlHandlerConfig.isIntegrator(targetPage)) && this.wcmMode != WCMMode.EDIT) {
            return this.recursiveResolveLink(targetPage, link);
        }
        String linkUrl = null;
        if (targetPage != null) {
            link.setTargetPage(targetPage);
            LinkArgs linkArgs = linkRequest.getLinkArgs();
            String selectors = linkArgs.getSelectors();
            String fileExtension = StringUtils.defaultString((String)linkArgs.getExtension(), (String)"html");
            String suffix = linkArgs.getSuffix();
            String queryString = linkArgs.getQueryString();
            String fragment = linkArgs.getFragment();
            queryString = (String)props.get("linkQueryParam", (Object)queryString);
            fragment = (String)props.get("linkFragment", (Object)fragment);
            linkUrl = resolvingUrlHandler.get(targetPage).selectors(selectors).extension(fileExtension).suffix(suffix).queryString(queryString).fragment(fragment).urlMode(linkArgs.getUrlMode()).buildExternalLinkUrl(targetPage);
        }
        if (linkUrl == null && referenceSet) {
            link.setLinkReferenceInvalid(true);
        }
        link.setUrl(linkUrl);
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Link recursiveResolveLink(Page redirectPage, Link link) {
        LinkRequest linkRequest = link.getLinkRequest();
        LinkRequest redirectLinkRequest = new LinkRequest(redirectPage.getContentResource(), null, linkRequest.getLinkArgs());
        LinkResolveCounter linkResolveCounter = LinkResolveCounter.get();
        try {
            linkResolveCounter.increaseCount();
            if (linkResolveCounter.isMaximumReached()) {
                link.setUrl(null);
                Link link2 = link;
                return link2;
            }
            Link link3 = this.linkHandler.get(redirectLinkRequest).build();
            return link3;
        }
        finally {
            linkResolveCounter.decreaseCount();
        }
    }

    private Page getTargetPage(String targetPath, InternalLinkResolverOptions options) {
        if (StringUtils.isEmpty((CharSequence)targetPath)) {
            return null;
        }
        String rewrittenPath = options.isRewritePathToContext() ? this.urlHandler.rewritePathToContext(SyntheticNavigatableResource.get(targetPath, this.resourceResolver)) : targetPath;
        if (StringUtils.isEmpty((CharSequence)rewrittenPath)) {
            return null;
        }
        Page targetPage = this.pageManager.getPage(rewrittenPath);
        if (this.acceptPage(targetPage, options)) {
            return targetPage;
        }
        return null;
    }
}

