/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkArgs;
import io.wcm.handler.link.LinkBuilder;
import io.wcm.handler.link.LinkComponentPropertyResolver;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.impl.LinkHandlerImpl;
import io.wcm.handler.url.UrlMode;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LinkBuilderImpl
implements LinkBuilder {
    private final LinkHandlerImpl linkHandler;
    private final Resource resource;
    private final Page page;
    private final String reference;
    private LinkArgs linkArgs = new LinkArgs();
    private static final Logger log = LoggerFactory.getLogger(LinkBuilderImpl.class);

    LinkBuilderImpl(@Nullable Resource resource, @NotNull LinkHandlerImpl linkHandler, @Nullable ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        this.resource = resource;
        this.page = null;
        this.reference = null;
        this.linkHandler = linkHandler;
        if (resource != null) {
            try (LinkComponentPropertyResolver resolver = LinkBuilderImpl.getLinkComponentPropertyResolver(resource, componentPropertyResolverFactory);){
                this.linkArgs.linkTargetUrlFallbackProperty(resolver.getLinkTargetUrlFallbackProperty());
            }
            catch (Exception ex) {
                log.warn("Error closing component property resolver.", (Throwable)ex);
            }
        }
    }

    private static LinkComponentPropertyResolver getLinkComponentPropertyResolver(@NotNull Resource resource, @Nullable ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        if (componentPropertyResolverFactory != null) {
            return new LinkComponentPropertyResolver(resource, componentPropertyResolverFactory);
        }
        return new LinkComponentPropertyResolver(resource);
    }

    LinkBuilderImpl(Page page, LinkHandlerImpl linkHandler) {
        this.resource = null;
        this.page = page;
        this.reference = null;
        this.linkHandler = linkHandler;
    }

    LinkBuilderImpl(String reference, LinkHandlerImpl linkHandler) {
        this.resource = null;
        this.page = null;
        this.reference = reference;
        this.linkHandler = linkHandler;
    }

    LinkBuilderImpl(LinkRequest linkRequest, LinkHandlerImpl linkHandler) {
        if (linkRequest == null) {
            throw new IllegalArgumentException("Link request is null.");
        }
        this.resource = linkRequest.getResource();
        this.page = linkRequest.getPage();
        this.reference = linkRequest.getReference();
        this.linkHandler = linkHandler;
        this.linkArgs = linkRequest.getLinkArgs().clone();
    }

    @Override
    @NotNull
    public LinkBuilder args(@NotNull LinkArgs value) {
        if (value == null) {
            throw new IllegalArgumentException("LinkArgs is null.");
        }
        this.linkArgs = value.clone();
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder urlMode(@Nullable UrlMode value) {
        this.linkArgs.urlMode(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder dummyLink(boolean value) {
        this.linkArgs.dummyLink(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder dummyLinkUrl(@Nullable String value) {
        this.linkArgs.dummyLinkUrl(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder selectors(@Nullable String value) {
        this.linkArgs.selectors(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder extension(@Nullable String value) {
        this.linkArgs.extension(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder suffix(@Nullable String value) {
        this.linkArgs.suffix(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder queryString(@Nullable String value) {
        this.linkArgs.queryString(value);
        return this;
    }

    @Override
    @NotNull
    public LinkBuilder fragment(@Nullable String value) {
        this.linkArgs.fragment(value);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    @NotNull
    public LinkBuilder linkTargetUrlFallbackProperty(String ... propertyNames) {
        this.linkArgs.linkTargetUrlFallbackProperty(propertyNames);
        return this;
    }

    @Override
    @NotNull
    public Link build() {
        LinkRequest request = new LinkRequest(this.resource, this.page, this.reference, this.linkArgs);
        return this.linkHandler.processRequest(request);
    }

    @Override
    public String buildMarkup() {
        return this.build().getMarkup();
    }

    @Override
    public Anchor buildAnchor() {
        return this.build().getAnchor();
    }

    @Override
    public String buildUrl() {
        return this.build().getUrl();
    }
}

