/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link;

import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.wcm.handler.commons.dom.Anchor;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Rendition;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jdom2.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ProviderType
public final class Link {
    @NotNull
    private final LinkType linkType;
    @NotNull
    private LinkRequest linkRequest;
    private boolean linkReferenceInvalid;
    private Anchor anchor;
    private Function<Link, Anchor> anchorBuilder;
    private String url;
    private Page targetPage;
    private Asset targetAsset;
    private Rendition targetRendition;
    private List<Page> redirectPages;

    public Link(@NotNull LinkType linkType, @NotNull LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
        this.linkType = linkType;
    }

    @JsonUnwrapped
    @NotNull
    public LinkType getLinkType() {
        return this.linkType;
    }

    @JsonIgnore
    @NotNull
    public LinkRequest getLinkRequest() {
        return this.linkRequest;
    }

    public void setLinkRequest(@NotNull LinkRequest linkRequest) {
        this.linkRequest = linkRequest;
    }

    @JsonIgnore
    public boolean isLinkReferenceInvalid() {
        return this.linkReferenceInvalid;
    }

    public void setLinkReferenceInvalid(boolean linkReferenceInvalid) {
        this.linkReferenceInvalid = linkReferenceInvalid;
    }

    @JsonIgnore
    @Nullable
    public Anchor getAnchor() {
        if (this.anchor == null && this.anchorBuilder != null) {
            this.anchor = this.anchorBuilder.apply(this);
            this.anchorBuilder = null;
        }
        return this.anchor;
    }

    @JsonIgnore
    @Nullable
    public Map<String, String> getAnchorAttributes() {
        Anchor a = this.getAnchor();
        if (a == null) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : a.getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        return attributes;
    }

    public void setAnchorBuilder(@NotNull Function<Link, Anchor> anchorBuilder) {
        this.anchorBuilder = anchorBuilder;
    }

    @JsonIgnore
    @Nullable
    public String getMarkup() {
        Anchor a = this.getAnchor();
        if (a != null) {
            return StringUtils.removeEnd((String)a.toString(), (String)"</a>");
        }
        return null;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    @JsonIgnore
    @Nullable
    public Page getTargetPage() {
        return this.targetPage;
    }

    public void setTargetPage(@Nullable Page targetPage) {
        this.targetPage = targetPage;
    }

    @JsonIgnore
    @Nullable
    public Asset getTargetAsset() {
        return this.targetAsset;
    }

    public void setTargetAsset(@Nullable Asset targetAsset) {
        this.targetAsset = targetAsset;
    }

    @JsonIgnore
    @Nullable
    public Rendition getTargetRendition() {
        return this.targetRendition;
    }

    public void setTargetRendition(@Nullable Rendition targetRendition) {
        this.targetRendition = targetRendition;
    }

    @JsonIgnore
    @NotNull
    public List<Page> getRedirectPages() {
        if (this.redirectPages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.redirectPages);
    }

    public void addRedirectPage(@NotNull Page redirectPage) {
        if (this.redirectPages == null) {
            this.redirectPages = new LinkedList<Page>();
        }
        this.redirectPages.add(0, redirectPage);
    }

    public boolean isValid() {
        return this.getLinkType() != null && this.getUrl() != null && !StringUtils.equals((CharSequence)this.getUrl(), (CharSequence)"/invalid///link");
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        sb.append("valid", this.isValid());
        if (this.isValid()) {
            sb.append("url", (Object)this.getUrl());
        } else {
            sb.append("linkReferenceInvalid", this.linkReferenceInvalid);
        }
        sb.append("linkType", (Object)this.getLinkType());
        if (this.anchor != null) {
            sb.append("anchor", (Object)this.anchor.toString());
        }
        if (this.targetPage != null) {
            sb.append("targetPage", (Object)this.targetPage.getPath());
        }
        if (this.targetAsset != null) {
            sb.append("targetAsset", (Object)this.targetAsset.getPath());
        }
        if (this.targetRendition != null) {
            sb.append("targetRendition", (Object)this.targetRendition);
        }
        if (this.redirectPages != null && !this.redirectPages.isEmpty()) {
            sb.append("redirectPages", this.redirectPages.stream().map(Page::getPath).toArray());
        }
        sb.append("linkRequest", (Object)this.linkRequest);
        return sb.build();
    }
}

