/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.link.LinkArgs;
import io.wcm.wcm.commons.util.AemObjectReflectionToStringBuilder;
import io.wcm.wcm.commons.util.ToStringStyle;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class LinkRequest {
    private final Resource resource;
    private final Page page;
    private final String reference;
    private final LinkArgs linkArgs;
    private ValueMap resourceProperties;

    public LinkRequest(@Nullable Resource resource, @Nullable Page page, @Nullable LinkArgs linkArgs) {
        this(resource, page, null, linkArgs);
    }

    public LinkRequest(@Nullable Resource resource, @Nullable Page page, @Nullable String reference, @Nullable LinkArgs linkArgs) {
        this.resource = resource;
        this.page = page;
        this.reference = reference;
        this.linkArgs = linkArgs != null ? linkArgs : new LinkArgs();
        int linkParamCount = (resource != null ? 1 : 0) + (page != null ? 1 : 0) + (reference != null ? 1 : 0);
        if (linkParamCount > 1) {
            throw new IllegalArgumentException("Set only one of resource, page, or reference.");
        }
    }

    @Nullable
    public Resource getResource() {
        return this.resource;
    }

    @Nullable
    public Page getPage() {
        return this.page;
    }

    @Nullable
    public String getReference() {
        return this.reference;
    }

    @NotNull
    public LinkArgs getLinkArgs() {
        return this.linkArgs;
    }

    @NotNull
    public ValueMap getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = new ValueMapDecorator(new HashMap());
            if (this.resource != null) {
                this.resourceProperties.putAll((Map)this.resource.getValueMap());
            }
        }
        return this.resourceProperties;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        if (this.resource != null) {
            sb.append("resource", (Object)this.resource.getPath());
            sb.append("resourceProperties", (Object)AemObjectReflectionToStringBuilder.filteredValueMap((ValueMap)this.resource.getValueMap()));
        }
        if (this.page != null) {
            sb.append("page", (Object)this.page.getPath());
        }
        if (this.reference != null) {
            sb.append("reference", (Object)this.reference);
        }
        if (this.linkArgs != null) {
            sb.append("linkArgs", (Object)this.linkArgs);
        }
        return sb.build();
    }
}

