/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.day.cq.wcm.api.Page;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkArgs;
import io.wcm.handler.link.LinkBuilder;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.impl.LinkBuilderImpl;
import io.wcm.handler.link.spi.LinkHandlerConfig;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.InvalidLinkType;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={LinkHandler.class})
public final class LinkHandlerImpl
implements LinkHandler {
    @Self
    private Adaptable adaptable;
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Page currentPage;
    @OSGiService
    private ComponentPropertyResolverFactory componentPropertyResolverFactory;
    private static final Logger log = LoggerFactory.getLogger(LinkHandlerImpl.class);

    @Override
    @NotNull
    public LinkBuilder get(@Nullable Resource resource) {
        return new LinkBuilderImpl(resource, this, this.componentPropertyResolverFactory);
    }

    @Override
    @NotNull
    public LinkBuilder get(@Nullable Page page) {
        return new LinkBuilderImpl(page, this);
    }

    @Override
    @NotNull
    public LinkBuilder get(@Nullable String reference) {
        return new LinkBuilderImpl(reference, this);
    }

    @Override
    @NotNull
    public LinkBuilder get(@NotNull LinkRequest linkRequest) {
        return new LinkBuilderImpl(linkRequest, this, this.componentPropertyResolverFactory);
    }

    @NotNull
    @SuppressFBWarnings(value={"STYLE"})
    Link processRequest(@NotNull LinkRequest linkRequest) {
        List<Class<? extends LinkProcessor>> list;
        List<Class<? extends LinkMarkupBuilder>> linkMarkupBuilders;
        LinkRequest fallbackLinkRequest;
        List<Class<? extends LinkProcessor>> linkPreProcessors;
        LinkType linkType = null;
        List<Class<? extends LinkType>> linkTypes = this.linkHandlerConfig.getLinkTypes();
        if (linkTypes == null || linkTypes.isEmpty()) {
            throw new RuntimeException("No link types defined.");
        }
        for (Class<? extends LinkType> candidateLinkTypeClass : linkTypes) {
            LinkType candidateLinkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, candidateLinkTypeClass);
            if (!candidateLinkType.accepts(linkRequest)) continue;
            linkType = candidateLinkType;
            break;
        }
        if (linkType == null) {
            linkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, InvalidLinkType.class);
        }
        Link link = new Link(linkType, linkRequest);
        if (log.isTraceEnabled()) {
            log.trace("Start processing link request (linkType={}): {}", (Object)linkType.getId(), (Object)linkRequest);
        }
        if ((linkPreProcessors = this.linkHandlerConfig.getPreProcessors()) != null) {
            for (Class clazz : linkPreProcessors) {
                log.trace("Apply pre processor ({}): {}", (Object)clazz, (Object)linkRequest);
                LinkProcessor processor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, (Class)clazz);
                link = processor.process(link);
                if (link != null) continue;
                throw new RuntimeException("LinkPreProcessor '" + String.valueOf(processor) + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        if ((link = linkType.resolveLink(link)) == null) {
            throw new RuntimeException("LinkType '" + String.valueOf(linkType) + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
        }
        if (!link.isValid() && (fallbackLinkRequest = this.getFallbackLinkRequest(linkRequest)) != null) {
            log.trace("Link is invalid ({}) - process fallback link request: {}", (Object)link, (Object)fallbackLinkRequest);
            Link link2 = this.processRequest(fallbackLinkRequest);
            if (link2.isValid()) {
                return link2;
            }
        }
        if ((linkMarkupBuilders = this.linkHandlerConfig.getMarkupBuilders()) != null) {
            link.setAnchorBuilder(l -> {
                for (Class linkMarkupBuilderClass : linkMarkupBuilders) {
                    LinkMarkupBuilder linkMarkupBuilder = (LinkMarkupBuilder)AdaptTo.notNull((Adaptable)this.adaptable, (Class)linkMarkupBuilderClass);
                    if (!linkMarkupBuilder.accepts((Link)l)) continue;
                    log.trace("Apply link markup builder ({}): {}", (Object)linkMarkupBuilderClass, (Object)linkRequest);
                    return linkMarkupBuilder.build((Link)l);
                }
                return null;
            });
        }
        if ((list = this.linkHandlerConfig.getPostProcessors()) != null) {
            for (Class<? extends LinkProcessor> processorClass : list) {
                log.trace("Apply post processor ({}): {}", processorClass, (Object)linkRequest);
                LinkProcessor processor = (LinkProcessor)AdaptTo.notNull((Adaptable)this.adaptable, processorClass);
                link = processor.process(link);
                if (link != null) continue;
                throw new RuntimeException("LinkPostProcessor '" + String.valueOf(processor) + "' returned null, page '" + (this.currentPage != null ? this.currentPage.getPath() : "-") + "'.");
            }
        }
        log.debug("Finished link processing: {}", (Object)link);
        return link;
    }

    @Override
    public Link invalid() {
        LinkType linkType = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, InvalidLinkType.class);
        return new Link(linkType, new LinkRequest(null, null, null));
    }

    @Nullable
    private LinkRequest getFallbackLinkRequest(@NotNull LinkRequest linkRequest) {
        Resource resource = linkRequest.getResource();
        if (resource == null) {
            return null;
        }
        String[] linkTargetUrlFallbackProperty = linkRequest.getLinkArgs().getLinkTargetUrlFallbackProperty();
        if (linkTargetUrlFallbackProperty == null || linkTargetUrlFallbackProperty.length == 0) {
            return null;
        }
        String linkTargetUrl = null;
        for (String propertyName : linkTargetUrlFallbackProperty) {
            linkTargetUrl = (String)resource.getValueMap().get(propertyName, String.class);
            if (StringUtils.isNotBlank((CharSequence)linkTargetUrl)) break;
        }
        if (StringUtils.isBlank(linkTargetUrl)) {
            return null;
        }
        LinkArgs fallbackLinkArgs = linkRequest.getLinkArgs().clone();
        String[] nullArray = null;
        fallbackLinkArgs.linkTargetUrlFallbackProperty(nullArray);
        return new LinkRequest(null, null, linkTargetUrl, fallbackLinkArgs);
    }
}

