/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.impl;

import com.adobe.aem.wcm.seo.sitemap.externalizer.SitemapLinkExternalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.UrlModes;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapLinkExternalizer.class, org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer.class}, property={"service.ranking:Integer=500", "seoSitemapLinkExternalizer=wcmio"})
public class SeoSitemapLinkExternalizerImpl
implements SitemapLinkExternalizer {
    private static final String HTML_EXTENSION = ".html";
    static final String TARGET_FILTER_PROPERTY = "seoSitemapLinkExternalizer";
    static final String TARGET_FILTER_VALUE = "wcmio";
    private final Logger log = LoggerFactory.getLogger(SeoSitemapLinkExternalizerImpl.class);
    @Reference
    private PageManagerFactory pageManagerFactory;
    @Reference(target="(!(seoSitemapLinkExternalizer=wcmio))")
    private SitemapLinkExternalizer aemSitemapLinkExternalizer;

    @NotNull
    public String externalize(SlingHttpServletRequest request, String path) {
        this.log.debug("Use AEM SitemapLinkExternalizer.externalize(SlingHttpServletRequest,String) for path {}", (Object)path);
        return this.aemSitemapLinkExternalizer.externalize(request, path);
    }

    @NotNull
    public String externalize(Resource resource) {
        Page page = this.getPageForResource(resource);
        String externalizedUrl = this.externalizePageLink(page);
        if (externalizedUrl != null) {
            this.log.debug("Externalize {} to {}", (Object)resource, (Object)externalizedUrl);
            return StringUtils.removeEnd((String)externalizedUrl, (String)HTML_EXTENSION);
        }
        this.log.debug("Fallback to AEM SitemapLinkExternalizer.externalize(Resource) for {}", (Object)resource);
        return this.aemSitemapLinkExternalizer.externalize(resource);
    }

    @NotNull
    public String externalize(ResourceResolver resourceResolver, String path) {
        String pagePath = StringUtils.removeEnd((String)path, (String)HTML_EXTENSION);
        Page page = this.getPageForPath(resourceResolver, pagePath);
        String externalizedUrl = this.externalizePageLink(page);
        if (externalizedUrl != null) {
            this.log.debug("Externalize {} to {}", (Object)path, (Object)externalizedUrl);
            return externalizedUrl;
        }
        this.log.debug("Fallback to AEM SitemapLinkExternalizer.externalize(ResourceResolver,String) for {}", (Object)path);
        return this.aemSitemapLinkExternalizer.externalize(resourceResolver, path);
    }

    @Nullable
    private Page getPageForPath(ResourceResolver resourceResolver, String path) {
        PageManager pageManager = this.pageManagerFactory.getPageManager(resourceResolver);
        return pageManager.getPage(path);
    }

    @Nullable
    private Page getPageForResource(Resource resource) {
        Page page = (Page)resource.adaptTo(Page.class);
        if (page == null) {
            PageManager pageManager = this.pageManagerFactory.getPageManager(resource.getResourceResolver());
            page = pageManager.getContainingPage(resource);
        }
        return page;
    }

    @Nullable
    private String externalizePageLink(@Nullable Page page) {
        UrlHandler urlHandler;
        LinkHandler linkHandler;
        String url;
        if (page != null && (url = (linkHandler = (LinkHandler)AdaptTo.notNull((Adaptable)page.getContentResource(), LinkHandler.class)).get(page).urlMode(UrlModes.FULL_URL).buildUrl()) != null && (urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)page.getContentResource(), UrlHandler.class)).isExternalized(url)) {
            return url;
        }
        return null;
    }
}

