/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.processor;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.url.UrlHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractInternalLinkInheritUrlParamLinkPostProcessor
implements LinkProcessor {
    @Self
    private UrlHandler urlHandler;
    private final Set<String> inheritUrlParameterNames;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected AbstractInternalLinkInheritUrlParamLinkPostProcessor(Set<String> inheritUrlParameterNames) {
        this.inheritUrlParameterNames = inheritUrlParameterNames;
    }

    @Override
    @NotNull
    public final Link process(@NotNull Link link) {
        if (link.isValid() && (StringUtils.equals((CharSequence)link.getLinkType().getId(), (CharSequence)"internal") || StringUtils.equals((CharSequence)link.getLinkType().getId(), (CharSequence)"internalCrossContext"))) {
            String url = link.getUrl();
            try {
                URI uri = new URI(url);
                Object path = uri.getPath();
                if (uri.getScheme() != null && uri.getHost() != null) {
                    path = uri.getScheme() + "://" + uri.getHost() + (String)(uri.getPort() == -1 ? "" : ":" + uri.getPort()) + (String)path;
                }
                url = this.urlHandler.get((String)path).queryString(uri.getRawQuery(), this.inheritUrlParameterNames).fragment(uri.getFragment()).build();
                link.setUrl(url);
            }
            catch (URISyntaxException ex) {
                this.log.warn("Skipping post-processing or URL: {}", (Object)url, (Object)ex);
            }
        }
        return link;
    }
}

