/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.spi;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.link.markup.DummyLinkMarkupBuilder;
import io.wcm.handler.link.markup.SimpleLinkMarkupBuilder;
import io.wcm.handler.link.processor.DefaultInternalLinkInheritUrlParamLinkPostProcessor;
import io.wcm.handler.link.spi.LinkMarkupBuilder;
import io.wcm.handler.link.spi.LinkProcessor;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.ExternalLinkType;
import io.wcm.handler.link.type.InternalLinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.handler.url.ui.SiteRoot;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.resource.ResourceType;
import io.wcm.wcm.commons.util.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class LinkHandlerConfig
implements ContextAwareService {
    private static final List<Class<? extends LinkType>> DEFAULT_LINK_TYPES = List.of(InternalLinkType.class, ExternalLinkType.class, MediaLinkType.class);
    private static final List<Class<? extends LinkMarkupBuilder>> DEFAULT_LINK_MARKUP_BUILDERS = List.of(SimpleLinkMarkupBuilder.class, DummyLinkMarkupBuilder.class);
    private static final List<Class<? extends LinkProcessor>> DEFAULT_POST_PROCESSORS = List.of(DefaultInternalLinkInheritUrlParamLinkPostProcessor.class);
    static final String REDIRECT_RESOURCE_TYPE = "wcm-io/handler/link/components/page/redirect";
    public static final String DEFAULT_ROOT_PATH_CONTENT = "/content";
    public static final String DEFAULT_ROOT_PATH_MEDIA = "/content/dam";

    @NotNull
    public List<Class<? extends LinkType>> getLinkTypes() {
        return DEFAULT_LINK_TYPES;
    }

    @NotNull
    public List<Class<? extends LinkMarkupBuilder>> getMarkupBuilders() {
        return DEFAULT_LINK_MARKUP_BUILDERS;
    }

    @NotNull
    public List<Class<? extends LinkProcessor>> getPreProcessors() {
        return Collections.emptyList();
    }

    @NotNull
    public List<Class<? extends LinkProcessor>> getPostProcessors() {
        return DEFAULT_POST_PROCESSORS;
    }

    public boolean isValidLinkTarget(@NotNull Page page) {
        return true;
    }

    public boolean isRedirect(@NotNull Page page) {
        return ResourceType.is((Resource)page.getContentResource(), (String)REDIRECT_RESOURCE_TYPE) || StringUtils.isNotBlank((CharSequence)((CharSequence)page.getProperties().get("cq:redirectTarget", String.class)));
    }

    @Nullable
    public String getLinkRootPath(@NotNull Page page, @NotNull String linkTypeId) {
        if (StringUtils.equals((CharSequence)linkTypeId, (CharSequence)"internal")) {
            if (Path.isExperienceFragmentPath((String)page.getPath()) || Path.isEditableTemplatePath((String)page.getPath())) {
                return DEFAULT_ROOT_PATH_CONTENT;
            }
            return ((SiteRoot)AdaptTo.notNull((Adaptable)page.getContentResource(), SiteRoot.class)).getRootPath(page);
        }
        if (StringUtils.equals((CharSequence)linkTypeId, (CharSequence)"internalCrossContext")) {
            return DEFAULT_ROOT_PATH_CONTENT;
        }
        if (StringUtils.equals((CharSequence)linkTypeId, (CharSequence)"media")) {
            return DEFAULT_ROOT_PATH_MEDIA;
        }
        return null;
    }
}

