/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkType;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class ExternalLinkType
extends LinkType {
    @NotNull
    public static final String ID = "external";
    private static final Pattern EXTERNALIZED_PATTERN = Pattern.compile("^([^/]+:|//|#).+?");

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getLabel() {
        return "External";
    }

    @Override
    public String getPrimaryLinkRefProperty() {
        return "linkExternalRef";
    }

    @Override
    @Nullable
    public String getEditComponentResourceType() {
        return "wcm-io/handler/link/components/granite/form/linktype/external";
    }

    @Override
    public boolean hasRichTextPlugin() {
        return true;
    }

    @Override
    public boolean accepts(@NotNull String linkRef) {
        if (linkRef == null) {
            return false;
        }
        return EXTERNALIZED_PATTERN.matcher(linkRef).matches();
    }

    @Override
    @NotNull
    public Link resolveLink(@NotNull Link link) {
        ValueMap props = link.getLinkRequest().getResourceProperties();
        String linkUrl = StringUtils.defaultString((String)((String)props.get("linkExternalRef", String.class)), (String)link.getLinkRequest().getReference());
        if (StringUtils.isBlank((CharSequence)linkUrl)) {
            linkUrl = null;
        }
        link.setUrl(linkUrl);
        return link;
    }

    @NotNull
    public static Resource getSyntheticLinkResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @NotNull String url) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkType", ID);
        map.put("linkExternalRef", url);
        return new SyntheticLinkResource(resourceResolver, path, map);
    }

    public String toString() {
        return ID;
    }
}

