/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.handler.link.type.helpers.InternalLinkResolver;
import io.wcm.handler.link.type.helpers.InternalLinkResolverOptions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class InternalLinkType
extends LinkType {
    @NotNull
    public static final String ID = "internal";
    @NotNull
    private final InternalLinkResolverOptions resolverOptions = new InternalLinkResolverOptions().primaryLinkRefProperty(this.getPrimaryLinkRefProperty()).rewritePathToContext(true).useTargetContext(false);
    @Self
    private InternalLinkResolver internalLinkResolver;

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getLabel() {
        return "Internal (same site)";
    }

    @Override
    public String getPrimaryLinkRefProperty() {
        return "linkContentRef";
    }

    @Override
    @Nullable
    public String getEditComponentResourceType() {
        return "wcm-io/handler/link/components/granite/form/linktype/internal";
    }

    @Override
    public boolean hasRichTextPlugin() {
        return true;
    }

    @Override
    public boolean accepts(@NotNull String linkRef) {
        return StringUtils.startsWith((CharSequence)linkRef, (CharSequence)"/content/") && !MediaLinkType.isDefaultMediaContentPath(linkRef);
    }

    @Override
    public boolean accepts(@NotNull LinkRequest linkRequest) {
        if (this.internalLinkResolver.acceptPage(linkRequest.getPage(), this.resolverOptions)) {
            return true;
        }
        return super.accepts(linkRequest);
    }

    @Override
    @NotNull
    public Link resolveLink(@NotNull Link link) {
        return this.internalLinkResolver.resolveLink(link, this.resolverOptions);
    }

    @NotNull
    public static Resource getSyntheticLinkResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @NotNull String pageRef) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkType", ID);
        map.put("linkContentRef", pageRef);
        return new SyntheticLinkResource(resourceResolver, path, map);
    }

    public String toString() {
        return ID;
    }
}

