/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type;

import io.wcm.handler.link.Link;
import io.wcm.handler.link.LinkRequest;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.spi.LinkType;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaHandler;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class MediaLinkType
extends LinkType {
    private static final String DEFAULT_DAM_ROOT = "/content/dam/";
    @NotNull
    public static final String ID = "media";
    @Self
    private MediaHandler mediaHandler;

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getLabel() {
        return "Asset";
    }

    @Override
    public String getPrimaryLinkRefProperty() {
        return "linkMediaRef";
    }

    @Override
    @Nullable
    public String getEditComponentResourceType() {
        return "wcm-io/handler/link/components/granite/form/linktype/media";
    }

    @Override
    public boolean hasRichTextPlugin() {
        return true;
    }

    @Override
    public boolean accepts(@NotNull String linkRef) {
        return MediaLinkType.isDefaultMediaContentPath(linkRef);
    }

    @Override
    @NotNull
    public Link resolveLink(@NotNull Link link) {
        LinkRequest linkRequest = link.getLinkRequest();
        ValueMap props = linkRequest.getResourceProperties();
        String mediaRef = StringUtils.defaultString((String)((String)props.get("linkMediaRef", String.class)), (String)link.getLinkRequest().getReference());
        boolean isDownload = (Boolean)props.get("linkMediaDownload", (Object)false);
        MediaArgs mediaArgs = new MediaArgs().download(true).contentDispositionAttachment(isDownload).webOptimizedImageDeliveryDisabled(true).urlMode(linkRequest.getLinkArgs().getUrlMode());
        Media media = this.mediaHandler.get(mediaRef, mediaArgs).build();
        link.setUrl(media.getUrl());
        link.setTargetAsset(media.getAsset());
        link.setTargetRendition(media.getRendition());
        if (link.getUrl() == null && StringUtils.isNotEmpty((CharSequence)mediaRef)) {
            link.setLinkReferenceInvalid(true);
        }
        return link;
    }

    public static boolean isDefaultMediaContentPath(String path) {
        return StringUtils.startsWith((CharSequence)path, (CharSequence)DEFAULT_DAM_ROOT);
    }

    @NotNull
    public static Resource getSyntheticLinkResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @NotNull String mediaRef) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("linkType", ID);
        map.put("linkMediaRef", mediaRef);
        return new SyntheticLinkResource(resourceResolver, path, map);
    }

    public String toString() {
        return ID;
    }
}

