/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.link.type.helpers;

import org.jetbrains.annotations.NotNull;

public final class LinkResolveCounter {
    private static final ThreadLocal<LinkResolveCounter> THREAD_LOCAL = ThreadLocal.withInitial(LinkResolveCounter::new);
    private static final int MAX_COUNT = 5;
    private int count;

    public int getCount() {
        return this.count;
    }

    public void increaseCount() {
        ++this.count;
    }

    public void decreaseCount() {
        if (this.count == 0) {
            throw new IllegalStateException("Cannot decrease, counter is already 0.");
        }
        --this.count;
        if (this.count == 0) {
            THREAD_LOCAL.remove();
        }
    }

    public boolean isMaximumReached() {
        return this.count > 5;
    }

    @NotNull
    public static LinkResolveCounter get() {
        return THREAD_LOCAL.get();
    }
}

