/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.image.Layer;
import com.drew.lang.annotations.Nullable;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.impl.AbstractMediaFileServlet;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.media.impl.ResourceLayerUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=file", "sling.servlet.selectors=image_file", "sling.servlet.resourceTypes=nt:file", "sling.servlet.resourceTypes=nt:resource", "sling.servlet.methods=GET"})
public final class ImageFileServlet
extends AbstractMediaFileServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "image_file";
    @Reference
    private AssetStore assetStore;

    @Override
    protected byte[] getBinaryData(Resource resource, SlingHttpServletRequest request) throws IOException {
        Layer layer;
        String rotationString;
        String cropString;
        MediaHandlerConfig config = (MediaHandlerConfig)AdaptTo.notNull((Adaptable)request, MediaHandlerConfig.class);
        int width = 0;
        int height = 0;
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors.length >= 3) {
            width = NumberUtils.toInt((String)selectors[1]);
            height = NumberUtils.toInt((String)selectors[2]);
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        CropDimension cropDimension = null;
        if (selectors.length >= 4 && !StringUtils.equals((CharSequence)(cropString = selectors[3]), (CharSequence)"-")) {
            try {
                cropDimension = CropDimension.fromCropString(cropString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int rotation = 0;
        if (selectors.length >= 5 && !ImageTransformation.isValidRotation(rotation = NumberUtils.toInt((String)(rotationString = selectors[4])))) {
            rotation = 0;
        }
        if ((layer = ResourceLayerUtil.toLayer(resource, this.assetStore)) == null) {
            return null;
        }
        if (cropDimension != null) {
            layer.crop(cropDimension.getRectangle());
        }
        if (rotation != 0) {
            layer.rotate((double)rotation);
        }
        if (width <= layer.getWidth() && height <= layer.getHeight()) {
            layer.resize(width, height);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String contentType = this.getContentType(resource, request);
        layer.write(contentType, config.getDefaultImageQuality(contentType), (OutputStream)bos);
        bos.flush();
        return bos.toByteArray();
    }

    @Override
    protected String getContentType(Resource resource, SlingHttpServletRequest request) {
        String fileExtension;
        String fileName = request.getRequestPathInfo().getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)fileName) && StringUtils.equalsIgnoreCase((CharSequence)(fileExtension = StringUtils.substringAfterLast((String)fileName, (String)".")), (CharSequence)"png")) {
            return "image/png";
        }
        return "image/jpeg";
    }

    public static String getImageFileName(@NotNull String originalFilename) {
        String namePart = StringUtils.substringBeforeLast((String)originalFilename, (String)".");
        String extensionPart = StringUtils.substringAfterLast((String)originalFilename, (String)".");
        extensionPart = StringUtils.equalsIgnoreCase((CharSequence)extensionPart, (CharSequence)"png") ? "png" : "jpg";
        return namePart + "." + extensionPart;
    }

    @NotNull
    public static String buildSelectorString(long width, long height, @Nullable CropDimension cropDimension, @Nullable Integer rotation, boolean contentDispositionAttachment) {
        StringBuffer result = new StringBuffer().append(SELECTOR).append(".").append(Long.toString(width)).append(".").append(Long.toString(height));
        if (cropDimension != null) {
            result.append(".").append(cropDimension.getCropString());
        } else if (rotation != null) {
            result.append(".-");
        }
        if (rotation != null) {
            result.append(".").append(rotation.toString());
        }
        if (contentDispositionAttachment) {
            result.append(".").append("download_attachment");
        }
        return result.toString();
    }
}

