/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DamRendition;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;

public final class DamAsset
extends SlingAdaptable
implements Asset {
    private final DamContext damContext;
    private final CropDimension cropDimension;
    private final Integer rotation;
    private final MediaArgs defaultMediaArgs;
    private final ValueMap properties;

    public DamAsset(Media media, com.day.cq.dam.api.Asset damAsset, DynamicMediaSupportService dynamicMediaSupportService, Adaptable adaptable) {
        this.damContext = new DamContext(damAsset, dynamicMediaSupportService, adaptable);
        this.cropDimension = media.getCropDimension();
        this.rotation = media.getRotation();
        this.defaultMediaArgs = media.getMediaRequest().getMediaArgs();
        this.properties = new ValueMapDecorator(damAsset.getMetadata());
    }

    @Override
    public String getTitle() {
        String title = this.damContext.getAsset().getName();
        Object titleObj = this.properties.get((Object)"dc:title");
        if (titleObj != null) {
            if (titleObj instanceof Object[]) {
                Object[] titleArray = (Object[])titleObj;
                if (titleArray.length > 0) {
                    title = StringUtils.defaultString((String)titleArray[0].toString(), (String)title);
                }
            } else {
                title = titleObj.toString();
            }
        }
        return title;
    }

    @Override
    public String getAltText() {
        return StringUtils.defaultString((String)this.defaultMediaArgs.getAltText(), (String)this.getTitle());
    }

    @Override
    public String getDescription() {
        return (String)this.properties.get("dc:description", String.class);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.damContext.getAsset().getPath();
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    public Rendition getDefaultRendition() {
        return this.getRendition(this.defaultMediaArgs);
    }

    @Override
    public Rendition getRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getDamRendition(mediaArgs);
        if (StringUtils.isEmpty((CharSequence)rendition.getUrl())) {
            rendition = null;
        }
        return rendition;
    }

    @Override
    public Rendition getImageRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isImage()) {
            return rendition;
        }
        return null;
    }

    @Override
    public Rendition getFlashRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isFlash()) {
            return rendition;
        }
        return null;
    }

    @Override
    public Rendition getDownloadRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isDownload()) {
            return rendition;
        }
        return null;
    }

    protected Rendition getDamRendition(MediaArgs mediaArgs) {
        return new DamRendition(this.cropDimension, this.rotation, mediaArgs, this.damContext);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == com.day.cq.dam.api.Asset.class) {
            return (AdapterType)this.damContext.getAsset();
        }
        if (type == Resource.class) {
            return (AdapterType)this.damContext.getAsset().adaptTo(Resource.class);
        }
        return (AdapterType)super.adaptTo(type);
    }
}

