/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DamContext
implements Adaptable {
    private final Asset asset;
    private final DynamicMediaSupportService dynamicMediaSupportService;
    private final Adaptable adaptable;
    private Boolean dynamicMediaEnabled;
    private String dynamicMediaObject;
    private String dynamicMediaProductionAssetUrl;
    private ImageProfile imageProfile;
    private static final ImageProfile NO_IMAGE_PROFILE = new ImageProfile(){

        @Override
        @NotNull
        public List<NamedDimension> getSmartCropDefinitions() {
            return Collections.emptyList();
        }
    };

    public DamContext(Asset asset, DynamicMediaSupportService dynamicMediaSupportService, Adaptable adaptable) {
        this.asset = asset;
        this.adaptable = adaptable;
        this.dynamicMediaSupportService = dynamicMediaSupportService;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public boolean isDynamicMediaEnabled() {
        if (this.dynamicMediaEnabled == null) {
            this.dynamicMediaEnabled = this.dynamicMediaSupportService.isDynamicMediaEnabled();
        }
        return this.dynamicMediaEnabled;
    }

    @Nullable
    public String getDynamicMediaObject() {
        if (this.dynamicMediaObject == null) {
            this.dynamicMediaObject = this.asset.getMetadataValueFromJcr("dam:scene7File");
        }
        return this.dynamicMediaObject;
    }

    public boolean isDynamicMediaAsset() {
        return StringUtils.isNotBlank((CharSequence)this.getDynamicMediaObject());
    }

    @Nullable
    public String getDynamicMediaProductionAssetUrl() {
        if (this.dynamicMediaProductionAssetUrl == null) {
            this.dynamicMediaProductionAssetUrl = this.dynamicMediaSupportService.getDynamicMediaProductionAssetUrl(this.asset);
        }
        return this.dynamicMediaProductionAssetUrl;
    }

    @Nullable
    public ImageProfile getImageProfile() {
        if (this.imageProfile == null) {
            this.imageProfile = this.dynamicMediaSupportService.getImageProfileForAsset(this.asset);
            if (this.imageProfile == null) {
                this.imageProfile = NO_IMAGE_PROFILE;
            }
        }
        if (this.imageProfile == NO_IMAGE_PROFILE) {
            return null;
        }
        return this.imageProfile;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return (AdapterType)this.adaptable.adaptTo(type);
    }
}

