/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.mediasource.dam.impl.DamAutoCropping;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DefaultRenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.TransformedRenditionHandler;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.caching.ModificationDate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class DamRendition
extends SlingAdaptable
implements Rendition {
    private final DamContext damContext;
    private final MediaArgs mediaArgs;
    private final RenditionMetadata rendition;
    private static final String DYNAMICMEDIA_IS_IMAGE_PATH = "/is/image/";

    DamRendition(CropDimension cropDimension, Integer rotation, MediaArgs mediaArgs, DamContext damContext) {
        DefaultRenditionHandler renditionHandler;
        this.damContext = damContext;
        this.mediaArgs = mediaArgs;
        RenditionMetadata resolvedRendition = null;
        if (cropDimension == null && rotation == null) {
            renditionHandler = new DefaultRenditionHandler(damContext);
            resolvedRendition = renditionHandler.getRendition(mediaArgs);
        } else {
            renditionHandler = new TransformedRenditionHandler(cropDimension, rotation, damContext);
            resolvedRendition = renditionHandler.getRendition(mediaArgs);
            if (resolvedRendition == null && cropDimension != null) {
                if (rotation != null) {
                    renditionHandler = new TransformedRenditionHandler(null, rotation, damContext);
                    resolvedRendition = renditionHandler.getRendition(mediaArgs);
                } else {
                    renditionHandler = new DefaultRenditionHandler(damContext);
                    resolvedRendition = renditionHandler.getRendition(mediaArgs);
                }
            }
        }
        if (resolvedRendition == null && mediaArgs.isAutoCrop()) {
            CropDimension autoCropDimension;
            TransformedRenditionHandler renditionHandler2;
            DamAutoCropping autoCropping = new DamAutoCropping(damContext.getAsset(), mediaArgs);
            List<CropDimension> autoCropDimensions = autoCropping.calculateAutoCropDimensions();
            Iterator<CropDimension> iterator = autoCropDimensions.iterator();
            while (iterator.hasNext() && (resolvedRendition = (renditionHandler2 = new TransformedRenditionHandler(autoCropDimension = iterator.next(), rotation, damContext)).getRendition(mediaArgs)) == null) {
            }
        }
        this.rendition = resolvedRendition;
    }

    @Override
    public String getUrl() {
        String productionAssetUrl;
        String dynamicMediaPath;
        if (this.rendition == null) {
            return null;
        }
        String url = null;
        if (!this.mediaArgs.isDynamicMediaDisabled() && this.damContext.isDynamicMediaEnabled() && this.damContext.isDynamicMediaAsset() && (dynamicMediaPath = this.rendition.getDynamicMediaPath(this.mediaArgs.isContentDispositionAttachment(), this.damContext)) != null && (productionAssetUrl = this.damContext.getDynamicMediaProductionAssetUrl()) != null) {
            url = productionAssetUrl + DYNAMICMEDIA_IS_IMAGE_PATH + dynamicMediaPath;
        }
        if (url == null) {
            UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)this.damContext, UrlHandler.class);
            String mediaPath = this.rendition.getMediaPath(this.mediaArgs.isContentDispositionAttachment());
            url = urlHandler.get(mediaPath).urlMode(this.mediaArgs.getUrlMode()).buildExternalResourceUrl(this.rendition.adaptTo(Resource.class));
        }
        return url;
    }

    @Override
    public String getPath() {
        if (this.rendition != null) {
            return this.rendition.getRendition().getPath();
        }
        return null;
    }

    @Override
    public String getFileName() {
        if (this.rendition != null) {
            return this.rendition.getFileName(this.mediaArgs.isContentDispositionAttachment());
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.getFileName());
    }

    @Override
    public long getFileSize() {
        if (this.rendition != null) {
            return this.rendition.getFileSize();
        }
        return 0L;
    }

    @Override
    public String getMimeType() {
        if (this.rendition != null) {
            return this.rendition.getMimeType();
        }
        return null;
    }

    @Override
    public Date getModificationDate() {
        if (this.rendition != null) {
            return ModificationDate.get((Resource)((Resource)this.rendition.getRendition().adaptTo(Resource.class)));
        }
        return null;
    }

    @Override
    public MediaFormat getMediaFormat() {
        if (this.rendition != null) {
            return this.rendition.getMediaFormat();
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public ValueMap getProperties() {
        if (this.rendition != null) {
            return ((Resource)this.rendition.getRendition().adaptTo(Resource.class)).getValueMap();
        }
        return ValueMap.EMPTY;
    }

    @Override
    public boolean isImage() {
        return MediaFileType.isImage(this.getFileExtension());
    }

    @Override
    public boolean isBrowserImage() {
        return MediaFileType.isBrowserImage(this.getFileExtension());
    }

    @Override
    public boolean isVectorImage() {
        return MediaFileType.isVectorImage(this.getFileExtension());
    }

    @Override
    public boolean isFlash() {
        return MediaFileType.isFlash(this.getFileExtension());
    }

    @Override
    public boolean isDownload() {
        return !this.isImage() && !this.isFlash();
    }

    @Override
    public long getWidth() {
        if (this.rendition != null) {
            return this.rendition.getWidth();
        }
        return 0L;
    }

    @Override
    public long getHeight() {
        if (this.rendition != null) {
            return this.rendition.getHeight();
        }
        return 0L;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        AdapterType result;
        if (this.rendition != null && (result = this.rendition.adaptTo(type)) != null) {
            return result;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        if (this.rendition != null) {
            return this.rendition.toString();
        }
        return super.toString();
    }
}

