/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.mediasource.dam.impl.DamAutoCropping;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DefaultRenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualTransformedRenditionMetadata;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TransformedRenditionHandler
extends DefaultRenditionHandler {
    private final CropDimension cropDimension;
    private final Integer rotation;

    TransformedRenditionHandler(CropDimension cropDimension, Integer rotation, DamContext damContext) {
        super(damContext);
        this.cropDimension = cropDimension;
        this.rotation = rotation != null && ImageTransformation.isValidRotation(rotation) ? rotation : null;
    }

    @Override
    protected Set<RenditionMetadata> postProcessCandidates(Set<RenditionMetadata> candidates) {
        VirtualTransformedRenditionMetadata cropRendition;
        TreeSet<RenditionMetadata> processedCandidates = new TreeSet<RenditionMetadata>(candidates);
        if (this.cropDimension != null && (cropRendition = this.getCropRendition()) != null) {
            processedCandidates.clear();
            processedCandidates.add(cropRendition);
            return processedCandidates;
        }
        return this.rotateSourceRenditions(processedCandidates);
    }

    private NavigableSet<RenditionMetadata> rotateSourceRenditions(Set<RenditionMetadata> candidates) {
        if (this.rotation == null) {
            return new TreeSet<RenditionMetadata>(candidates);
        }
        return candidates.stream().filter(rendition -> !rendition.isVectorImage()).map(rendition -> new VirtualTransformedRenditionMetadata(rendition.getRendition(), ImageTransformation.rotateMapWidth(rendition.getWidth(), rendition.getHeight(), this.rotation), ImageTransformation.rotateMapHeight(rendition.getWidth(), rendition.getHeight(), this.rotation), null, this.rotation)).collect(Collectors.toCollection(TreeSet::new));
    }

    private VirtualTransformedRenditionMetadata getCropRendition() {
        RenditionMetadata original = this.getOriginalRendition();
        if (original == null || original.isVectorImage()) {
            return null;
        }
        Double scaleFactor = this.getCropScaleFactor();
        CropDimension scaledCropDimension = new CropDimension(Math.round((double)this.cropDimension.getLeft() * scaleFactor), Math.round((double)this.cropDimension.getTop() * scaleFactor), Math.round((double)this.cropDimension.getWidth() * scaleFactor), Math.round((double)this.cropDimension.getHeight() * scaleFactor), this.cropDimension.isAutoCrop());
        return new VirtualTransformedRenditionMetadata(original.getRendition(), ImageTransformation.rotateMapWidth(scaledCropDimension.getWidth(), scaledCropDimension.getHeight(), this.rotation), ImageTransformation.rotateMapHeight(scaledCropDimension.getWidth(), scaledCropDimension.getHeight(), this.rotation), scaledCropDimension, this.rotation);
    }

    private double getCropScaleFactor() {
        RenditionMetadata original = this.getOriginalRendition();
        RenditionMetadata webEnabled = DamAutoCropping.getWebRenditionForCropping(this.getAsset());
        if (original == null || webEnabled == null || original.getWidth() == 0L || webEnabled.getWidth() == 0L) {
            return 1.0;
        }
        return Ratio.get(original.getWidth(), webEnabled.getWidth());
    }
}

