/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicMediaPath {
    private static final long MAX_WIDTH_HEIGHT = 4000L;

    private DynamicMediaPath() {
    }

    @NotNull
    public static String build(@NotNull DamContext damContext, long width, long height) {
        return DynamicMediaPath.build(damContext, width, height, null, null);
    }

    @NotNull
    public static String build(@NotNull DamContext damContext, long width, long height, @Nullable CropDimension cropDimension, @Nullable Integer rotation) {
        Optional<NamedDimension> smartCroppingDef;
        Dimension dimension = DynamicMediaPath.calcWidthHeight(width, height);
        if (cropDimension != null && cropDimension.isAutoCrop() && rotation == null && (smartCroppingDef = DynamicMediaPath.getSmartCropDimension(damContext, width, height)).isPresent()) {
            return damContext.getDynamicMediaObject() + "%3A" + smartCroppingDef.get().getName();
        }
        StringBuffer result = new StringBuffer();
        result.append(damContext.getDynamicMediaObject()).append("?");
        if (cropDimension != null) {
            result.append("crop=").append(cropDimension.getCropStringWidthHeight()).append("&");
        }
        if (rotation != null) {
            result.append("rotate=").append(rotation).append("&");
        }
        result.append("wid=").append(dimension.getWidth()).append("&").append("hei=").append(dimension.getHeight()).append("&").append("fit=stretch");
        return result.toString();
    }

    private static Dimension calcWidthHeight(long width, long height) {
        if (width > 4000L) {
            double ratio = Ratio.get(width, height);
            long newWidth = 4000L;
            long newHeight = Math.round((double)newWidth / ratio);
            return DynamicMediaPath.calcWidthHeight(newWidth, newHeight);
        }
        if (height > 4000L) {
            double ratio = Ratio.get(width, height);
            long newHeight = 4000L;
            long newWidth = Math.round((double)newHeight * ratio);
            return new Dimension(newWidth, newHeight);
        }
        return new Dimension(width, height);
    }

    private static Optional<NamedDimension> getSmartCropDimension(@NotNull DamContext damContext, long width, long height) {
        ImageProfile imageProfile = damContext.getImageProfile();
        if (imageProfile != null) {
            return imageProfile.getSmartCropDefinitions().stream().filter(def -> def.getWidth() == width && def.getHeight() == height).findFirst();
        }
        return Optional.empty();
    }
}

