/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.inline;

import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.mediasource.inline.InlineRendition;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class InlineAsset
extends SlingAdaptable
implements Asset {
    private final Adaptable adaptable;
    private final Resource resource;
    private final Media media;
    private final MediaArgs defaultMediaArgs;
    private final String fileName;

    InlineAsset(Resource resource, Media media, String fileName, Adaptable adaptable) {
        this.resource = resource;
        this.media = media;
        this.defaultMediaArgs = media.getMediaRequest().getMediaArgs();
        this.fileName = fileName;
        this.adaptable = adaptable;
    }

    @Override
    public String getTitle() {
        return this.fileName;
    }

    @Override
    public String getAltText() {
        return this.defaultMediaArgs.getAltText();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return this.resource.getValueMap();
    }

    @Override
    public Rendition getDefaultRendition() {
        return this.getRendition(this.defaultMediaArgs);
    }

    @Override
    public Rendition getRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getInlineRendition(mediaArgs);
        if (StringUtils.isEmpty((CharSequence)rendition.getUrl())) {
            rendition = null;
        }
        return rendition;
    }

    @Override
    public Rendition getImageRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isImage()) {
            return rendition;
        }
        return null;
    }

    @Override
    public Rendition getFlashRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isFlash()) {
            return rendition;
        }
        return null;
    }

    @Override
    public Rendition getDownloadRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isDownload()) {
            return rendition;
        }
        return null;
    }

    private Rendition getInlineRendition(MediaArgs mediaArgs) {
        return new InlineRendition(this.resource, this.media, mediaArgs, this.fileName, this.adaptable);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        return (AdapterType)super.adaptTo(type);
    }
}

