/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum MediaFileType {
    JPEG(new String[]{"image/jpeg"}, new String[]{"jpg", "jpeg"}, true),
    PNG(new String[]{"image/png"}, new String[]{"png"}, false),
    GIF(new String[]{"image/gif"}, new String[]{"gif"}, false),
    TIFF(new String[]{"image/tiff"}, new String[]{"tif", "tiff"}, false),
    SVG(new String[]{"image/svg+xml"}, new String[]{"svg"}, false);

    private final Set<String> contentTypes;
    private final Set<String> extensions;
    private final boolean imageQualityPercentage;
    private static final EnumSet<MediaFileType> IMAGE_FILE_TYPES;
    private static final EnumSet<MediaFileType> BROWSER_IMAGE_FILE_TYPES;
    private static final EnumSet<MediaFileType> VECTOR_IMAGE_FILE_TYPES;

    private MediaFileType(String[] contentTypes, String[] extensions, boolean imageQualityPercentage) {
        this.contentTypes = Set.of(contentTypes);
        this.extensions = Set.of(extensions);
        this.imageQualityPercentage = imageQualityPercentage;
    }

    public Set<String> getContentTypes() {
        return this.contentTypes;
    }

    public Set<String> getExtensions() {
        return this.extensions;
    }

    public boolean isImageQualityPercentage() {
        return this.imageQualityPercentage;
    }

    public static boolean isImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getImageFileExtensions() {
        return MediaFileType.getFileExtensions(IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getImageContentTypes() {
        return MediaFileType.getContentTypes(IMAGE_FILE_TYPES);
    }

    public static boolean isBrowserImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(BROWSER_IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getBrowserImageFileExtensions() {
        return MediaFileType.getFileExtensions(BROWSER_IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getBrowserImageContentTypes() {
        return MediaFileType.getContentTypes(BROWSER_IMAGE_FILE_TYPES);
    }

    public static boolean isVectorImage(@Nullable String fileExtension) {
        return MediaFileType.isExtension(VECTOR_IMAGE_FILE_TYPES, fileExtension);
    }

    @NotNull
    public static Set<String> getVectorImageFileExtensions() {
        return MediaFileType.getFileExtensions(VECTOR_IMAGE_FILE_TYPES);
    }

    @NotNull
    public static Set<String> getVectorImageContentTypes() {
        return MediaFileType.getContentTypes(VECTOR_IMAGE_FILE_TYPES);
    }

    private static Set<String> getContentTypes(@NotNull EnumSet<MediaFileType> fileTypes) {
        return fileTypes.stream().flatMap(type -> type.getContentTypes().stream()).collect(Collectors.toSet());
    }

    private static boolean isExtension(@NotNull EnumSet<MediaFileType> fileTypes, @Nullable String fileExtension) {
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return false;
        }
        return fileTypes.stream().anyMatch(type -> type.getExtensions().contains(StringUtils.lowerCase((String)fileExtension)));
    }

    private static Set<String> getFileExtensions(@NotNull EnumSet<MediaFileType> fileTypes) {
        return fileTypes.stream().flatMap(type -> type.getExtensions().stream()).collect(Collectors.toSet());
    }

    @Nullable
    public static MediaFileType getByContentType(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        String contentTypeLowerCase = StringUtils.toRootLowerCase((String)contentType);
        return Stream.of(MediaFileType.values()).filter(type -> type.getContentTypes().contains(contentTypeLowerCase)).findFirst().orElse(null);
    }

    @Nullable
    public static MediaFileType getByFileExtensions(@Nullable String extension) {
        if (extension == null) {
            return null;
        }
        String extensionLowerCase = StringUtils.toRootLowerCase((String)extension);
        return Stream.of(MediaFileType.values()).filter(type -> type.getExtensions().contains(extensionLowerCase)).findFirst().orElse(null);
    }

    static {
        IMAGE_FILE_TYPES = EnumSet.of(GIF, JPEG, PNG, TIFF, SVG);
        BROWSER_IMAGE_FILE_TYPES = EnumSet.of(GIF, JPEG, PNG, SVG);
        VECTOR_IMAGE_FILE_TYPES = EnumSet.of(SVG);
    }
}

