/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=wcmio_handler_media_mediaformat_list", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET"})
public final class DefaultMediaFormatListProvider
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Set<MediaFormat> mediaFormats = this.getMediaFormats(request);
        ArrayList<MediaFormatItem> mediaFormatList = new ArrayList<MediaFormatItem>();
        if (mediaFormats != null) {
            for (MediaFormat mediaFormat : mediaFormats) {
                if (mediaFormat.isInternal()) continue;
                MediaFormatItem mediaFormatItem = new MediaFormatItem();
                mediaFormatItem.name = mediaFormat.getName();
                mediaFormatItem.text = mediaFormat.toString();
                mediaFormatItem.width = mediaFormat.getWidth();
                mediaFormatItem.height = mediaFormat.getHeight();
                mediaFormatItem.widthMin = mediaFormat.getMinWidth();
                mediaFormatItem.heightMin = mediaFormat.getMinHeight();
                mediaFormatItem.widthHeightMin = mediaFormat.getMinWidthHeight();
                mediaFormatItem.isImage = mediaFormat.isImage();
                mediaFormatItem.ratio = mediaFormat.getRatio();
                mediaFormatItem.ratioWidth = mediaFormat.getRatioWidthAsDouble();
                mediaFormatItem.ratioHeight = mediaFormat.getRatioHeightAsDouble();
                mediaFormatItem.ratioDisplayString = mediaFormat.getRatioDisplayString();
                mediaFormatList.add(mediaFormatItem);
            }
        }
        response.setContentType(ContentType.JSON);
        response.getWriter().write(OBJECT_MAPPER.writeValueAsString(mediaFormatList));
    }

    protected Set<MediaFormat> getMediaFormats(SlingHttpServletRequest request) {
        MediaFormatHandler mediaFormatHandler = (MediaFormatHandler)request.adaptTo(MediaFormatHandler.class);
        if (mediaFormatHandler != null) {
            return mediaFormatHandler.getMediaFormats();
        }
        return Collections.emptySet();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class MediaFormatItem {
        private String name;
        private String text;
        private long width;
        private long height;
        private long widthMin;
        private long heightMin;
        private long widthHeightMin;
        private boolean isImage;
        private double ratio;
        private double ratioWidth;
        private double ratioHeight;
        private String ratioDisplayString;

        MediaFormatItem() {
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public long getWidthMin() {
            return this.widthMin;
        }

        public long getHeightMin() {
            return this.heightMin;
        }

        public long getWidthHeightMin() {
            return this.widthHeightMin;
        }

        @JsonProperty(value="isImage")
        public boolean isImage() {
            return this.isImage;
        }

        public double getRatio() {
            return this.ratio;
        }

        public double getRatioWidth() {
            return this.ratioWidth;
        }

        public double getRatioHeight() {
            return this.ratioHeight;
        }

        public String getRatioDisplayString() {
            return this.ratioDisplayString;
        }
    }
}

