/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format.impl;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.impl.MediaFormatVisitor;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MediaFormatSupport {
    private MediaFormatSupport() {
    }

    @Nullable
    public static String[] getRequestedFileExtensions(@NotNull MediaArgs mediaArgs) {
        SetUtils.SetView intersection;
        HashSet<String> mediaArgsFileExtensions = new HashSet<String>();
        String[] mediaArgsFileExtensionsArray = mediaArgs.getFileExtensions();
        if (mediaArgsFileExtensionsArray != null && mediaArgsFileExtensionsArray.length > 0) {
            mediaArgsFileExtensions.addAll(List.of(mediaArgs.getFileExtensions()));
        }
        final HashSet mediaFormatFileExtensions = new HashSet();
        MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<Object>(){

            @Override
            @Nullable
            public Object visit(@NotNull MediaFormat mediaFormat) {
                if (mediaFormat.getExtensions() != null && mediaFormat.getExtensions().length > 0) {
                    mediaFormatFileExtensions.addAll(List.of(mediaFormat.getExtensions()));
                }
                return null;
            }
        });
        Object fileExtensions = !mediaArgsFileExtensions.isEmpty() && !mediaFormatFileExtensions.isEmpty() ? ((intersection = SetUtils.intersection(mediaArgsFileExtensions, mediaFormatFileExtensions)).isEmpty() ? null : intersection.toArray(new String[0])) : (!mediaArgsFileExtensions.isEmpty() ? mediaArgsFileExtensions.toArray(new String[0]) : mediaFormatFileExtensions.toArray(new String[0]));
        return fileExtensions;
    }

    @Nullable
    public static <T> T visitMediaFormats(@NotNull MediaArgs mediaArgs, @NotNull MediaFormatVisitor<T> mediaFormatVisitor) {
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        if (mediaFormats != null) {
            for (MediaFormat mediaFormat : mediaFormats) {
                T returnValue = mediaFormatVisitor.visit(mediaFormat);
                if (returnValue == null) continue;
                return returnValue;
            }
        }
        return null;
    }
}

