/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.impl.ImageTransformation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageFileServletSelector {
    private int width;
    private int height;
    private CropDimension cropDimension;
    private int rotation;
    private int quality;

    ImageFileServletSelector(@NotNull String[] selectors) {
        this.parseParams(selectors);
        this.validateParams();
    }

    private void parseParams(@NotNull String[] selectors) {
        String cropString;
        if (selectors.length >= 3) {
            this.width = NumberUtils.toInt((String)selectors[1]);
            this.height = NumberUtils.toInt((String)selectors[2]);
        }
        if (selectors.length >= 4 && !StringUtils.equals((CharSequence)(cropString = selectors[3]), (CharSequence)"-")) {
            try {
                this.cropDimension = CropDimension.fromCropString(cropString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (selectors.length >= 5) {
            String rotationString = selectors[4];
            this.rotation = NumberUtils.toInt((String)rotationString);
        }
        if (selectors.length >= 6) {
            String qualityString = selectors[5];
            this.quality = NumberUtils.toInt((String)qualityString);
        }
    }

    private void validateParams() {
        if (this.width < 0) {
            this.width = 0;
        }
        if (this.height < 0) {
            this.height = 0;
        }
        if (!ImageTransformation.isValidRotation(this.rotation)) {
            this.rotation = 0;
        }
        if (this.quality < 0 || this.quality > 100) {
            this.quality = 0;
        }
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    @Nullable
    CropDimension getCropDimension() {
        return this.cropDimension;
    }

    int getRotation() {
        return this.rotation;
    }

    int getQuality() {
        return this.quality;
    }

    @NotNull
    public static String build(long width, long height, @Nullable CropDimension cropDimension, @Nullable Integer rotation, @Nullable Double imageQualityPercentage, boolean contentDispositionAttachment) {
        long quality;
        StringBuilder result = new StringBuilder().append("image_file").append(".").append(Long.toString(width)).append(".").append(Long.toString(height));
        if (cropDimension != null) {
            result.append(".").append(cropDimension.getCropString());
        } else if (rotation != null || imageQualityPercentage != null) {
            result.append(".-");
        }
        if (rotation != null) {
            result.append(".").append(rotation.toString());
        } else if (imageQualityPercentage != null) {
            result.append(".0");
        }
        if (imageQualityPercentage != null && (quality = Math.round(imageQualityPercentage * 100.0)) > 0L) {
            result.append(".").append(Long.toString(quality));
        }
        if (contentDispositionAttachment) {
            result.append(".").append("download_attachment");
        }
        return result.toString();
    }
}

