/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageTransformation {
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;

    private ImageTransformation() {
    }

    public static boolean isValidRotation(int rotation) {
        return rotation == 90 || rotation == 180 || rotation == 270;
    }

    public static long rotateMapWidth(long width, long height, @Nullable Integer rotation) {
        if (rotation != null && (rotation == 90 || rotation == 270)) {
            return height;
        }
        return width;
    }

    public static long rotateMapHeight(long width, long height, @Nullable Integer rotation) {
        if (rotation != null && (rotation == 90 || rotation == 270)) {
            return width;
        }
        return height;
    }

    @NotNull
    public static Dimension rotateMapDimension(@NotNull Dimension dimension, @Nullable Integer rotation) {
        if (dimension instanceof CropDimension) {
            return ImageTransformation.rotateMapDimension((CropDimension)dimension, rotation);
        }
        if (rotation != null && (rotation == 90 || rotation == 270)) {
            return new Dimension(dimension.getHeight(), dimension.getWidth());
        }
        return dimension;
    }

    @NotNull
    public static CropDimension rotateMapDimension(@NotNull CropDimension dimension, @Nullable Integer rotation) {
        if (rotation != null && (rotation == 90 || rotation == 270)) {
            CropDimension cropDimension = dimension;
            return new CropDimension(cropDimension.getTop(), cropDimension.getLeft(), cropDimension.getHeight(), cropDimension.getWidth());
        }
        return dimension;
    }

    @NotNull
    public static CropDimension calculateAutoCropDimension(long givenWidth, long givenHeight, double expectedRatio) {
        long left;
        long top;
        long height;
        long width;
        double givenRatio = Ratio.get(givenWidth, givenHeight);
        if (givenRatio > expectedRatio) {
            width = Math.round((double)givenHeight * expectedRatio);
            height = givenHeight;
            top = 0L;
            left = Math.round(((double)givenWidth - (double)width) / 2.0);
        } else {
            width = givenWidth;
            height = Math.round((double)givenWidth / expectedRatio);
            top = Math.round(((double)givenHeight - (double)height) / 2.0);
            left = 0L;
        }
        return new CropDimension(left, top, width, height, true);
    }
}

