/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.MediaComponentPropertyResolver;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.impl.MediaHandlerImpl;
import io.wcm.handler.media.markup.DragDropSupport;
import io.wcm.handler.mediasource.dam.AemRenditionType;
import io.wcm.handler.url.UrlMode;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MediaBuilderImpl
implements MediaBuilder {
    private final MediaHandlerImpl mediaHandler;
    private final Resource resource;
    private final String mediaRef;
    private MediaArgs mediaArgs = new MediaArgs();
    private MediaRequest.MediaPropertyNames mediaPropertyNames = new MediaRequest.MediaPropertyNames();
    private List<MediaArgs.PictureSource> pictureSourceSets = new ArrayList<MediaArgs.PictureSource>();
    private static final Logger log = LoggerFactory.getLogger(MediaBuilderImpl.class);

    MediaBuilderImpl(@Nullable Resource resource, @NotNull MediaHandlerImpl mediaHandler, @NotNull ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        this.resource = resource;
        this.mediaRef = null;
        this.mediaHandler = mediaHandler;
        if (resource != null) {
            this.resolveDefaultSettingsFromPolicyAndComponent(resource, componentPropertyResolverFactory);
        }
    }

    private void resolveDefaultSettingsFromPolicyAndComponent(@NotNull Resource contextResource, @NotNull ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        try (MediaComponentPropertyResolver resolver = new MediaComponentPropertyResolver(contextResource, componentPropertyResolverFactory);){
            this.mediaArgs.mediaFormatOptions(resolver.getMediaFormatOptions());
            this.mediaArgs.autoCrop(resolver.isAutoCrop());
            this.mediaArgs.imageSizes(resolver.getImageSizes());
            this.mediaArgs.pictureSources(resolver.getPictureSources());
        }
        catch (Exception ex) {
            log.warn("Error closing component property resolver.", (Throwable)ex);
        }
    }

    MediaBuilderImpl(String mediaRef, Resource contextResource, MediaHandlerImpl mediaHandler, @NotNull ComponentPropertyResolverFactory componentPropertyResolverFactory) {
        this.resource = contextResource;
        this.mediaRef = mediaRef;
        this.mediaHandler = mediaHandler;
        if (contextResource != null) {
            this.resolveDefaultSettingsFromPolicyAndComponent(contextResource, componentPropertyResolverFactory);
        }
    }

    MediaBuilderImpl(MediaRequest mediaRequest, MediaHandlerImpl mediaHandler) {
        if (mediaRequest == null) {
            throw new IllegalArgumentException("Media request is null.");
        }
        this.resource = mediaRequest.getResource();
        this.mediaRef = mediaRequest.getMediaRef();
        this.mediaArgs = mediaRequest.getMediaArgs().clone();
        this.mediaPropertyNames = mediaRequest.getMediaPropertyNames();
        this.mediaHandler = mediaHandler;
    }

    @Override
    @NotNull
    public MediaBuilder args(@NotNull MediaArgs value) {
        if (value == null) {
            throw new IllegalArgumentException("MediaArgs is null.");
        }
        this.mediaArgs = value.clone();
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormats(MediaFormat ... values) {
        this.mediaArgs.mediaFormats(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mandatoryMediaFormats(MediaFormat ... values) {
        this.mediaArgs.mandatoryMediaFormats(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormat(@NotNull MediaFormat value) {
        this.mediaArgs.mediaFormat(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormatsMandatory(boolean value) {
        this.mediaArgs.mediaFormatsMandatory(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormatNames(String ... values) {
        this.mediaArgs.mediaFormatNames(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mandatoryMediaFormatNames(String ... values) {
        this.mediaArgs.mandatoryMediaFormatNames(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormatName(@NotNull String value) {
        this.mediaArgs.mediaFormatName(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mediaFormatOptions(MediaArgs.MediaFormatOption ... values) {
        this.mediaArgs.mediaFormatOptions(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder autoCrop(boolean value) {
        this.mediaArgs.autoCrop(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder fileExtensions(String ... values) {
        this.mediaArgs.fileExtensions(values);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder fileExtension(@NotNull String value) {
        this.mediaArgs.fileExtension(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder enforceOutputFileExtension(@NotNull String value) {
        this.mediaArgs.enforceOutputFileExtension(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder urlMode(@NotNull UrlMode value) {
        this.mediaArgs.urlMode(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder fixedWidth(long value) {
        this.mediaArgs.fixedWidth(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder fixedHeight(long value) {
        this.mediaArgs.fixedHeight(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder fixedDimension(long widthValue, long heightValue) {
        this.mediaArgs.fixedDimension(widthValue, heightValue);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder contentDispositionAttachment(boolean value) {
        this.mediaArgs.contentDispositionAttachment(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder altText(@NotNull String value) {
        this.mediaArgs.altText(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder forceAltValueFromAsset(boolean value) {
        this.mediaArgs.forceAltValueFromAsset(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder decorative(boolean value) {
        this.mediaArgs.decorative(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder dummyImage(boolean value) {
        this.mediaArgs.dummyImage(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder dummyImageUrl(@NotNull String value) {
        this.mediaArgs.dummyImageUrl(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder imageQualityPercentage(@NotNull Double value) {
        this.mediaArgs.imageQualityPercentage(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder includeAssetAemRenditions(@NotNull Set<AemRenditionType> value) {
        this.mediaArgs.includeAssetAemRenditions(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder includeAssetThumbnails(boolean value) {
        this.mediaArgs.includeAssetThumbnails(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder includeAssetWebRenditions(boolean value) {
        this.mediaArgs.includeAssetWebRenditions(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder dragDropSupport(@NotNull DragDropSupport value) {
        this.mediaArgs.dragDropSupport(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder property(@NotNull String key, @Nullable Object value) {
        this.mediaArgs.property(key, value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder imageSizes(@NotNull String sizes, long ... widths) {
        this.mediaArgs.imageSizes(new MediaArgs.ImageSizes(sizes, widths));
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder imageSizes(@NotNull String sizes, MediaArgs.WidthOption ... widthOptions) {
        this.mediaArgs.imageSizes(new MediaArgs.ImageSizes(sizes, widthOptions));
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder pictureSource(@NotNull MediaArgs.PictureSource pictureSource) {
        this.pictureSourceSets.add(pictureSource);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder dynamicMediaDisabled(boolean value) {
        this.mediaArgs.dynamicMediaDisabled(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder webOptimizedImageDeliveryDisabled(boolean value) {
        this.mediaArgs.webOptimizedImageDeliveryDisabled(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder refProperty(@NotNull String value) {
        this.mediaPropertyNames.refProperty(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder cropProperty(@NotNull String value) {
        this.mediaPropertyNames.cropProperty(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder rotationProperty(@NotNull String value) {
        this.mediaPropertyNames.rotationProperty(value);
        return this;
    }

    @Override
    @NotNull
    public MediaBuilder mapProperty(@NotNull String value) {
        this.mediaPropertyNames.mapProperty(value);
        return this;
    }

    @Override
    @NotNull
    public Media build() {
        if (!this.pictureSourceSets.isEmpty()) {
            this.mediaArgs.pictureSources(this.pictureSourceSets.toArray(new MediaArgs.PictureSource[this.pictureSourceSets.size()]));
        }
        if (this.mediaArgs.getImageSizes() != null && this.mediaArgs.getPictureSources() != null) {
            throw new IllegalArgumentException("Image sizes must not be used together with pictures source sets.");
        }
        MediaRequest request = new MediaRequest(this.resource, this.mediaRef, this.mediaArgs, this.mediaPropertyNames);
        return this.mediaHandler.processRequest(request);
    }

    @Override
    public String buildMarkup() {
        return this.build().getMarkup();
    }

    @Override
    public HtmlElement buildElement() {
        return this.build().getElement();
    }

    @Override
    public String buildUrl() {
        return this.build().getUrl();
    }
}

