/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatBuilder;
import io.wcm.handler.media.format.MediaFormatHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MediaFormatResolver {
    private final MediaFormatHandler mediaFormatHandler;
    private static final Logger log = LoggerFactory.getLogger(MediaFormatResolver.class);
    static final String MEDIAFORMAT_NAME_SEPARATOR = "___";

    MediaFormatResolver(MediaFormatHandler mediaFormatHandler) {
        this.mediaFormatHandler = mediaFormatHandler;
    }

    public boolean resolve(MediaArgs mediaArgs) {
        return this.resolveMediaFormatOptionsByNames(mediaArgs) && this.resolvePictureSourcesByNames(mediaArgs) && this.addResponsiveImageMediaFormats(mediaArgs);
    }

    private boolean resolveMediaFormatOptionsByNames(MediaArgs mediaArgs) {
        MediaArgs.MediaFormatOption[] mediaFormatOptions = mediaArgs.getMediaFormatOptions();
        if (mediaFormatOptions == null) {
            return true;
        }
        boolean resolutionSuccessful = true;
        for (int i = 0; i < mediaFormatOptions.length; ++i) {
            MediaArgs.MediaFormatOption option = mediaFormatOptions[i];
            String mediaFormatName = option.getMediaFormatName();
            if (option.getMediaFormat() != null || mediaFormatName == null) continue;
            MediaFormat mediaFormat = this.mediaFormatHandler.getMediaFormat(mediaFormatName);
            if (mediaFormat == null) {
                log.warn("Media format name '{}' is invalid.", (Object)option.getMediaFormatName());
                resolutionSuccessful = false;
            }
            mediaFormatOptions[i] = new MediaArgs.MediaFormatOption(mediaFormat, option.isMandatory());
        }
        mediaArgs.mediaFormatOptions(mediaFormatOptions);
        return resolutionSuccessful;
    }

    private boolean resolvePictureSourcesByNames(MediaArgs mediaArgs) {
        MediaArgs.PictureSource[] pictureSources = mediaArgs.getPictureSources();
        if (pictureSources == null) {
            return true;
        }
        boolean resolutionSuccessful = true;
        for (int i = 0; i < pictureSources.length; ++i) {
            MediaArgs.PictureSource pictureSource = pictureSources[i];
            String mediaFormatName = pictureSource.getMediaFormatName();
            if (pictureSource.getMediaFormat() != null || mediaFormatName == null) continue;
            MediaFormat mediaFormat = this.mediaFormatHandler.getMediaFormat(mediaFormatName);
            if (mediaFormat == null) {
                log.warn("Media format name '{}' is invalid.", (Object)pictureSource.getMediaFormatName());
                resolutionSuccessful = false;
                continue;
            }
            pictureSources[i] = new MediaArgs.PictureSource(mediaFormat).media(pictureSource.getMedia()).sizes(pictureSource.getSizes()).widthOptions(pictureSource.getWidthOptions());
        }
        mediaArgs.pictureSources(pictureSources);
        return resolutionSuccessful;
    }

    private boolean addResponsiveImageMediaFormats(MediaArgs mediaArgs) {
        LinkedHashMap<String, MediaArgs.MediaFormatOption> additionalMediaFormats = new LinkedHashMap<String, MediaArgs.MediaFormatOption>();
        if (!this.resolveForImageSizes(mediaArgs, additionalMediaFormats)) {
            return false;
        }
        this.resolveForResponsivePictureSources(mediaArgs, additionalMediaFormats);
        if (!additionalMediaFormats.isEmpty()) {
            ArrayList<MediaArgs.MediaFormatOption> allMediaFormats = new ArrayList<MediaArgs.MediaFormatOption>();
            MediaArgs.MediaFormatOption[] mediaFormatOptions = mediaArgs.getMediaFormatOptions();
            if (mediaFormatOptions != null) {
                allMediaFormats.addAll(Arrays.asList(mediaFormatOptions));
            }
            allMediaFormats.addAll(additionalMediaFormats.values());
            mediaArgs.mediaFormatOptions(allMediaFormats.toArray(new MediaArgs.MediaFormatOption[0]));
        }
        return true;
    }

    private boolean resolveForImageSizes(MediaArgs mediaArgs, Map<String, MediaArgs.MediaFormatOption> additionalMediaFormats) {
        MediaArgs.ImageSizes imageSizes = mediaArgs.getImageSizes();
        if (imageSizes == null) {
            return true;
        }
        Object[] mediaFormats = mediaArgs.getMediaFormats();
        if (ArrayUtils.isEmpty((Object[])mediaFormats)) {
            log.warn("No media format with ratio given - unable to fulfill resolve image sizes.");
            return false;
        }
        Arrays.stream(mediaFormats).filter(Objects::nonNull).forEach(mediaFormat -> this.generateMediaFormatsForWidths(additionalMediaFormats, (MediaFormat)mediaFormat, true, imageSizes.getWidthOptions()));
        return true;
    }

    private void resolveForResponsivePictureSources(MediaArgs mediaArgs, Map<String, MediaArgs.MediaFormatOption> additionalMediaFormats) {
        MediaArgs.PictureSource[] pictureSources = mediaArgs.getPictureSources();
        if (pictureSources == null || pictureSources.length == 0) {
            return;
        }
        for (MediaArgs.PictureSource pictureSource : pictureSources) {
            this.generateMediaFormatsForWidths(additionalMediaFormats, pictureSource.getMediaFormat(), false, pictureSource.getWidthOptions());
        }
    }

    private void generateMediaFormatsForWidths(@NotNull Map<String, MediaArgs.MediaFormatOption> additionalMediaFormats, @Nullable MediaFormat mediaFormat, boolean setParent, MediaArgs.WidthOption ... widthOptions) {
        if (mediaFormat == null || widthOptions == null) {
            return;
        }
        for (MediaArgs.WidthOption widthOption : widthOptions) {
            MediaFormat widthMediaFormat = MediaFormatBuilder.create(mediaFormat.getName() + MEDIAFORMAT_NAME_SEPARATOR + widthOption.getWidth()).label(mediaFormat.getLabel()).extensions(mediaFormat.getExtensions()).ratio(mediaFormat.getRatio()).width(widthOption.getWidth()).property("parentMediaFormat", setParent ? mediaFormat : null).build();
            additionalMediaFormats.put(widthMediaFormat.getName(), new MediaArgs.MediaFormatOption(widthMediaFormat, widthOption.isMandatory()));
        }
    }
}

