/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import com.day.cq.wcm.api.WCMMode;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.sling.models.annotations.AemObject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AbstractImageMediaMarkupBuilder
implements MediaMarkupBuilder {
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private WCMMode wcmMode;
    @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private SlingHttpServletRequest request;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;

    protected void applyWcmMarkup(@Nullable HtmlElement mediaElement, @NotNull Media media) {
        Resource resource = media.getMediaRequest().getResource();
        if (mediaElement != null && resource != null && this.wcmMode != null) {
            switch (this.wcmMode) {
                case EDIT: {
                    media.getMediaSource().enableMediaDrop(mediaElement, media.getMediaRequest());
                    media.getMediaSource().setCustomIPECropRatios(mediaElement, media.getMediaRequest());
                    break;
                }
                case PREVIEW: {
                    media.getMediaSource().enableMediaDrop(mediaElement, media.getMediaRequest());
                    if (this.request != null) {
                        String refProperty = StringUtils.defaultString((String)media.getMediaRequest().getMediaPropertyNames().getRefProperty(), (String)this.mediaHandlerConfig.getMediaRefProperty());
                        MediaMarkupBuilderUtil.addDiffDecoration(mediaElement, resource, refProperty, this.request, this.mediaHandlerConfig);
                    }
                    media.getMediaSource().setCustomIPECropRatios(mediaElement, media.getMediaRequest());
                    break;
                }
            }
        }
    }

    protected void setAdditionalAttributes(@Nullable HtmlElement mediaElement, @NotNull Media media) {
        if (mediaElement == null) {
            return;
        }
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        for (Map.Entry entry : mediaArgs.getProperties().entrySet()) {
            if (StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"cssClass")) {
                mediaElement.addCssClass(entry.getValue().toString());
                continue;
            }
            mediaElement.setAttribute((String)entry.getKey(), entry.getValue().toString());
        }
    }

    @Nullable
    protected final WCMMode getWcmMode() {
        return this.wcmMode;
    }

    @Nullable
    protected final SlingHttpServletRequest getRequest() {
        return this.request;
    }
}

