/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import io.wcm.handler.commons.dom.Area;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.commons.dom.Map;
import io.wcm.handler.commons.dom.Picture;
import io.wcm.handler.commons.dom.Source;
import io.wcm.handler.commons.dom.Span;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.handler.media.markup.AbstractImageMediaMarkupBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ConsumerType
public class SimpleImageMediaMarkupBuilder
extends AbstractImageMediaMarkupBuilder {
    @Override
    public final boolean accepts(@NotNull Media media) {
        Rendition rendition = media.getRendition();
        return media.isValid() && rendition != null && rendition.isBrowserImage();
    }

    @Override
    public final HtmlElement build(@NotNull Media media) {
        HtmlElement mediaElement = this.getMediaElement(media);
        this.applyWcmMarkup(mediaElement, media);
        return mediaElement;
    }

    @Nullable
    protected HtmlElement getMediaElement(@NotNull Media media) {
        MediaArgs.PictureSource[] pictureSources = media.getMediaRequest().getMediaArgs().getPictureSources();
        if (pictureSources != null && pictureSources.length > 0) {
            return this.getPictureElement(media);
        }
        return this.getImageElement(media);
    }

    @Nullable
    protected HtmlElement getPictureElement(@NotNull Media media) {
        HtmlElement image;
        MediaArgs.PictureSource[] pictureSources = media.getMediaRequest().getMediaArgs().getPictureSources();
        Picture picture = new Picture();
        boolean foundAnySource = false;
        if (pictureSources != null) {
            for (MediaArgs.PictureSource pictureSource : pictureSources) {
                String srcSet;
                MediaFormat mediaFormat;
                Source source = new Source();
                if (pictureSource.getMedia() != null) {
                    source.setMedia(pictureSource.getMedia());
                }
                if (pictureSource.getSizes() != null) {
                    source.setSizes(pictureSource.getSizes());
                }
                if ((mediaFormat = pictureSource.getMediaFormat()) == null || (srcSet = this.getSrcSetRenditions(media, mediaFormat, pictureSource.getWidthOptions())) == null) continue;
                source.setSrcSet(srcSet);
                picture.add((HtmlElement)source);
                foundAnySource = true;
            }
        }
        if ((image = this.getImageElement(media)) == null) {
            return null;
        }
        if (foundAnySource) {
            if (image instanceof Span) {
                for (Element element : List.copyOf(image.getChildren())) {
                    element.detach();
                    picture.addContent((Content)element);
                }
            } else {
                picture.addContent((Content)image);
            }
            return picture;
        }
        return image;
    }

    @Nullable
    protected HtmlElement getImageElement(@NotNull Media media) {
        Image img = null;
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        Asset asset = media.getAsset();
        Rendition rendition = media.getRendition();
        String url = null;
        if (rendition != null) {
            url = rendition.getUrl();
        }
        if (url != null) {
            String srcSet;
            MediaFormat primaryMediaFormat;
            MediaArgs.ImageSizes imageSizes;
            img = new Image(url);
            String altText = null;
            if (asset != null) {
                altText = asset.getAltText();
            }
            if (altText != null) {
                img.setAlt(altText);
            }
            if (rendition != null && !rendition.isVectorImage() && mediaArgs.getImageSizes() == null && mediaArgs.getPictureSources() == null) {
                long width;
                long height = rendition.getHeight();
                if (height > 0L) {
                    img.setHeight(height);
                }
                if ((width = rendition.getWidth()) > 0L) {
                    img.setWidth(width);
                }
            }
            if ((imageSizes = mediaArgs.getImageSizes()) != null && (primaryMediaFormat = this.getFirstMediaFormat(media)) != null && (srcSet = this.getSrcSetRenditions(media, primaryMediaFormat, imageSizes.getWidthOptions())) != null) {
                img.setSrcSet(srcSet);
                img.setSizes(imageSizes.getSizes());
            }
        }
        this.setAdditionalAttributes((HtmlElement)img, media);
        return this.applyImageMap((HtmlElement)img, media);
    }

    @Nullable
    protected String getSrcSetRenditions(@NotNull Media media, @NotNull MediaFormat mediaFormat, MediaArgs.WidthOption ... widths) {
        if (widths == null) {
            return null;
        }
        return this.getSrcSetRenditions(media, mediaFormat, Arrays.stream(widths).mapToLong(MediaArgs.WidthOption::getWidth).toArray());
    }

    @Nullable
    protected String getSrcSetRenditions(@NotNull Media media, @NotNull MediaFormat mediaFormat, long ... widths) {
        StringBuilder srcset = new StringBuilder();
        for (long width : widths) {
            Optional<String> url = media.getRenditions().stream().filter(rendition -> (Ratio.matches(rendition.getRatio(), mediaFormat.getRatio()) || Ratio.matches(mediaFormat.getRatio(), 0.0)) && rendition.getWidth() == width).map(Rendition::getUrl).findFirst();
            if (!url.isPresent()) continue;
            if (srcset.length() > 0) {
                srcset.append(", ");
            }
            srcset.append(url.get()).append(" ").append(Long.toString(width)).append("w");
        }
        if (srcset.length() > 0) {
            return srcset.toString();
        }
        return null;
    }

    @Nullable
    protected final MediaFormat getFirstMediaFormatWithRatio(@NotNull Media media) {
        MediaFormat[] mediaFormats = media.getMediaRequest().getMediaArgs().getMediaFormats();
        if (mediaFormats != null) {
            for (MediaFormat mediaFormat : mediaFormats) {
                if (!mediaFormat.hasRatio()) continue;
                return mediaFormat;
            }
        }
        return null;
    }

    @Nullable
    protected final MediaFormat getFirstMediaFormat(@NotNull Media media) {
        return media.getRenditions().stream().map(Rendition::getMediaFormat).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    protected final HtmlElement applyImageMap(@Nullable HtmlElement element, @NotNull Media media) {
        List<ImageMapArea> mapData = media.getMap();
        if (!(element instanceof Image) || mapData == null) {
            return element;
        }
        String mapName = this.buildImageMapName(mapData, media);
        Span span = new Span();
        ((Image)element).setUseMap("#" + mapName);
        span.addContent((Content)element);
        Map map = new Map();
        map.setMapName(mapName);
        for (ImageMapArea areaData : mapData) {
            Area area = new Area();
            area.setShape(areaData.getShape());
            area.setCoords(areaData.getCoordinates());
            area.setHRef(areaData.getLinkUrl());
            if (areaData.getLinkWindowTarget() != null) {
                area.setTarget(areaData.getLinkWindowTarget());
            }
            if (areaData.getAltText() != null) {
                area.setAlt(areaData.getAltText());
            }
            map.addContent((Content)area);
        }
        span.addContent((Content)map);
        return span;
    }

    @NotNull
    protected final String buildImageMapName(@NotNull List<ImageMapArea> map, @NotNull Media media) {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (ImageMapArea area : map) {
            builder.append((Object)area);
        }
        return "map-" + builder.hashCode();
    }

    @Override
    public final boolean isValidMedia(@NotNull HtmlElement element) {
        Optional firstChild;
        Element imgChild;
        if (element instanceof Image) {
            Image img = (Image)element;
            return StringUtils.isNotEmpty((CharSequence)img.getSrc()) && !StringUtils.contains((CharSequence)img.getCssClass(), (CharSequence)"wcmio_mediahandler_wcm_dummy");
        }
        if (element instanceof Picture && (imgChild = element.getChild("img")) instanceof Image) {
            Image img = (Image)imgChild;
            return StringUtils.isNotEmpty((CharSequence)img.getSrc()) && !StringUtils.contains((CharSequence)element.getCssClass(), (CharSequence)"wcmio_mediahandler_wcm_dummy");
        }
        if (element instanceof Span && (firstChild = element.getChildren().stream().findFirst()).isPresent()) {
            return this.isValidMedia((HtmlElement)firstChild.get());
        }
        return false;
    }
}

