/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.spi;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.markup.DummyImageMediaMarkupBuilder;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.markup.SimpleImageMediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaProcessor;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.dam.AemRenditionType;
import io.wcm.handler.mediasource.dam.DamMediaSource;
import io.wcm.sling.commons.caservice.ContextAwareService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class MediaHandlerConfig
implements ContextAwareService {
    public static final double DEFAULT_IMAGE_QUALITY = 0.85;
    @Deprecated(since="2.0.0")
    public static final double DEFAULT_JPEG_QUALITY = 0.85;
    private static final List<Class<? extends MediaSource>> DEFAULT_MEDIA_SOURCES = List.of(DamMediaSource.class);
    private static final List<Class<? extends MediaMarkupBuilder>> DEFAULT_MEDIA_MARKUP_BUILDERS = List.of(SimpleImageMediaMarkupBuilder.class, DummyImageMediaMarkupBuilder.class);

    @NotNull
    public List<Class<? extends MediaSource>> getSources() {
        return DEFAULT_MEDIA_SOURCES;
    }

    @NotNull
    public List<Class<? extends MediaMarkupBuilder>> getMarkupBuilders() {
        return DEFAULT_MEDIA_MARKUP_BUILDERS;
    }

    @NotNull
    public List<Class<? extends MediaProcessor>> getPreProcessors() {
        return Collections.emptyList();
    }

    @NotNull
    public List<Class<? extends MediaProcessor>> getPostProcessors() {
        return Collections.emptyList();
    }

    public double getDefaultImageQuality(@Nullable String contentType) {
        MediaFileType mediaFileType = MediaFileType.getByContentType(contentType);
        if (mediaFileType != null && mediaFileType.isImageQualityPercentage()) {
            return this.getDefaultImageQualityPercentage();
        }
        if (mediaFileType == MediaFileType.GIF) {
            return 256.0;
        }
        return 1.0;
    }

    public double getDefaultImageQualityPercentage() {
        return 0.85;
    }

    public boolean useAdobeStandardNames() {
        return false;
    }

    @NotNull
    public String getMediaRefProperty() {
        if (this.useAdobeStandardNames()) {
            return "fileReference";
        }
        return "mediaRef";
    }

    @NotNull
    public String getMediaCropProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageCrop";
        }
        return "mediaCrop";
    }

    @NotNull
    public String getMediaRotationProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageRotate";
        }
        return "mediaRotate";
    }

    @NotNull
    public String getMediaMapProperty() {
        if (this.useAdobeStandardNames()) {
            return "imageMap";
        }
        return "mediaMap";
    }

    @NotNull
    public String getMediaAltTextProperty() {
        if (this.useAdobeStandardNames()) {
            return "alt";
        }
        return "mediaAltText";
    }

    @NotNull
    public String getMediaForceAltTextFromAssetProperty() {
        if (this.useAdobeStandardNames()) {
            return "altValueFromDAM";
        }
        return "mediaForceAltValueFromAsset";
    }

    @NotNull
    public String getMediaIsDecorativeProperty() {
        if (this.useAdobeStandardNames()) {
            return "isDecorative";
        }
        return "mediaIsDecorative";
    }

    @NotNull
    public String getMediaInlineNodeName() {
        if (this.useAdobeStandardNames()) {
            return "file";
        }
        return "mediaInline";
    }

    @Deprecated(since="2.0.0")
    public boolean includeAssetWebRenditionsByDefault() {
        return false;
    }

    @NotNull
    public Set<AemRenditionType> getIncludeAssetAemRenditionsByDefault() {
        if (this.includeAssetWebRenditionsByDefault()) {
            return EnumSet.of(AemRenditionType.WEB_RENDITION, AemRenditionType.VIDEO_RENDITION);
        }
        return EnumSet.of(AemRenditionType.VIDEO_RENDITION);
    }

    public boolean enforceVirtualRenditions() {
        return false;
    }

    @NotNull
    public Set<String> allowedIpeEditorTypes() {
        return MediaMarkupBuilderUtil.DEFAULT_ALLOWED_IPE_EDITOR_TYPES;
    }

    @NotNull
    public String getDamRootPath(@NotNull Page page) {
        return "/content/dam";
    }
}

