/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.ui;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import java.util.Arrays;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static void applyPictureSources(@NotNull MediaFormatHandler mediaFormatHandler, @NotNull MediaBuilder builder, String @NotNull [] mediaFormatNames, String @NotNull [] medias, String @NotNull [] widths) {
        for (int i = 0; i < mediaFormatNames.length && i < medias.length && i < widths.length; ++i) {
            MediaFormat mediaFormat = mediaFormatHandler.getMediaFormat(mediaFormatNames[i]);
            if (mediaFormat != null) {
                String media = medias[i];
                long[] widthsArray = ImageUtils.toWidthsArray(widths[i]);
                if (widthsArray.length <= 0) continue;
                MediaArgs.PictureSource pictureSource = new MediaArgs.PictureSource(mediaFormat);
                pictureSource.widths(widthsArray);
                if (StringUtils.isNotBlank((CharSequence)media)) {
                    pictureSource.media(media);
                }
                builder.pictureSource(pictureSource);
                continue;
            }
            LOG.warn("Ignoring invalid media format: {}", (Object)mediaFormatNames[i]);
        }
    }

    public static long[] toWidthsArray(@NotNull String widths) {
        if (StringUtils.isBlank((CharSequence)widths)) {
            return new long[0];
        }
        return Arrays.stream(StringUtils.split((String)widths, (String)",")).map(NumberUtils::toLong).filter(width -> width > 0L).sorted((l1, l2) -> Long.compare(l2, l1)).mapToLong(Long::longValue).toArray();
    }

    public static MediaArgs.WidthOption[] toWidthOptionArray(@NotNull String widthOptions) {
        if (StringUtils.isBlank((CharSequence)widthOptions)) {
            return new MediaArgs.WidthOption[0];
        }
        return (MediaArgs.WidthOption[])Arrays.stream(StringUtils.split((String)widthOptions, (String)",")).filter(StringUtils::isNotBlank).map(widthOption -> StringUtils.split((String)widthOption, (String)":")).filter(widthOptionArray -> ((String[])widthOptionArray).length == 2).map(widthOptionArray -> new MediaArgs.WidthOption(NumberUtils.toLong((String)widthOptionArray[0]), BooleanUtils.toBoolean((String)widthOptionArray[1]))).filter(widthOption -> widthOption.getWidth() > 0L).sorted((wo1, wo2) -> Long.compare(wo2.getWidth(), wo1.getWidth())).toArray(MediaArgs.WidthOption[]::new);
    }
}

