/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.ui;

import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.ui.ResourceMedia;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class MediaPlaceholder {
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Object media;
    @RequestAttribute(injectionStrategy=InjectionStrategy.OPTIONAL)
    private String classAppend;
    private String classAppendCombined;
    private String mediaInvalidReason;
    private static final Logger log = LoggerFactory.getLogger(MediaPlaceholder.class);

    @PostConstruct
    private void activate() {
        Media mediaMetadata = this.getMediaMetadata();
        if (mediaMetadata != null) {
            this.classAppendCombined = this.mergeClassAppend(this.getMediaDropCssClass(mediaMetadata), this.classAppend);
            this.mediaInvalidReason = this.getMediaInvalidReasonText(mediaMetadata);
        }
    }

    private Media getMediaMetadata() {
        if (this.media == null) {
            log.warn("No 'media' parameter passed to MediaPlaceholder model.");
            return null;
        }
        if (this.media instanceof Media) {
            return (Media)this.media;
        }
        if (this.media instanceof ResourceMedia) {
            return ((ResourceMedia)this.media).getMetadata();
        }
        log.warn("Invalid 'media' parameter passed to MediaPlaceholder model. Expected: {}, actual: {}", (Object)Media.class.getName(), (Object)this.media.getClass().getName());
        return null;
    }

    private String getMediaDropCssClass(Media mediaMetadata) {
        Image dummyImage = new Image();
        mediaMetadata.getMediaSource().enableMediaDrop((HtmlElement)dummyImage, mediaMetadata.getMediaRequest());
        return dummyImage.getCssClass();
    }

    private String getMediaInvalidReasonText(Media mediaMetadata) {
        MediaInvalidReason reason = mediaMetadata.getMediaInvalidReason();
        if (reason != null && reason != MediaInvalidReason.MEDIA_REFERENCE_MISSING) {
            return "io.wcm.handler.media.invalidReason." + reason.name();
        }
        return null;
    }

    @Nullable
    private String mergeClassAppend(String ... classAppends) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String classAppendItem : classAppends) {
            if (!StringUtils.isNotBlank((CharSequence)classAppendItem)) continue;
            result.addAll(Arrays.asList(StringUtils.split((String)classAppendItem, (String)" ")));
        }
        if (result.isEmpty()) {
            return null;
        }
        return StringUtils.join(result, (String)" ");
    }

    @Nullable
    public String getClassAppend() {
        return this.classAppendCombined;
    }

    @Nullable
    public String getMediaInvalidReason() {
        return this.mediaInvalidReason;
    }
}

