/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam;

import com.day.cq.dam.api.Rendition;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AemRenditionType {
    THUMBNAIL_RENDITION(Pattern.compile("^" + Pattern.quote("cq5dam.thumbnail") + "\\..*$")),
    WEB_RENDITION(Pattern.compile("^" + Pattern.quote("cq5dam.web") + "\\..*$")),
    VIDEO_RENDITION(Pattern.compile("^cq5dam\\.video\\..*$")),
    OTHER_RENDITION(Pattern.compile("^(cq5dam|cqdam)\\..*$"));

    private final Pattern namePattern;

    private AemRenditionType(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public boolean matches(@NotNull String renditionName) {
        return this.namePattern.matcher(renditionName).matches();
    }

    public boolean matches(@NotNull Rendition rendition) {
        return this.matches(rendition.getName());
    }

    @Nullable
    public static AemRenditionType forRendition(@NotNull String renditionName) {
        return Stream.of(AemRenditionType.values()).filter(type -> type.matches(renditionName)).findFirst().orElse(null);
    }

    @Nullable
    public static AemRenditionType forRendition(@NotNull Rendition rendition) {
        return AemRenditionType.forRendition(rendition.getName());
    }
}

