/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.SmartCrop;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DamAutoCropping {
    private final DamContext damContext;
    private final MediaArgs mediaArgs;

    DamAutoCropping(@NotNull DamContext damContext, @NotNull MediaArgs mediaArgs) {
        this.damContext = damContext;
        this.mediaArgs = mediaArgs;
    }

    public List<CropDimension> calculateAutoCropDimensions() {
        Stream<MediaFormat> mediaFormats = Arrays.stream((MediaFormat[])ObjectUtils.defaultIfNull((Object)this.mediaArgs.getMediaFormats(), (Object)new MediaFormat[0]));
        return mediaFormats.map(this::calculateAutoCropDimension).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private CropDimension calculateAutoCropDimension(@NotNull MediaFormat mediaFormat) {
        Dimension dimension;
        CropDimension result = null;
        double ratio = mediaFormat.getRatio();
        if (ratio > 0.0 && (result = this.getDynamicMediaCropDimension(ratio)) == null && (dimension = AssetRendition.getDimension(this.damContext.getAsset().getOriginal())) != null && dimension.getWidth() > 0L && dimension.getHeight() > 0L) {
            result = ImageTransformation.calculateAutoCropDimension(dimension.getWidth(), dimension.getHeight(), ratio);
        }
        return result;
    }

    @Nullable
    private CropDimension getDynamicMediaCropDimension(double requestedRatio) {
        NamedDimension smartCropDef;
        if (this.damContext.isDynamicMediaEnabled() && this.damContext.isDynamicMediaAsset() && this.damContext.isDynamicMediaValidateSmartCropRenditionSizes() && (smartCropDef = SmartCrop.getDimensionForRatio(this.damContext.getImageProfile(), requestedRatio)) != null) {
            return SmartCrop.getCropDimensionForAsset(this.damContext.getAsset(), this.damContext.getResourceResolver(), smartCropDef);
        }
        return null;
    }
}

