/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryService;
import io.wcm.handler.mediasource.ngdm.impl.ImageQualityPercentage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DamContext
implements Adaptable {
    private final Asset asset;
    private final MediaArgs mediaArgs;
    private final MediaHandlerConfig mediaHandlerConfig;
    private final DynamicMediaSupportService dynamicMediaSupportService;
    private final WebOptimizedImageDeliveryService webOptimizedImageDeliveryService;
    private final Adaptable adaptable;
    private String dynamicMediaObject;
    private String dynamicMediaServerUrl;
    private Dimension dynamicMediaImageSizeLimit;
    private ImageProfile imageProfile;
    private static final ImageProfile NO_IMAGE_PROFILE = new ImageProfile(){

        @Override
        @NotNull
        public List<NamedDimension> getSmartCropDefinitions() {
            return Collections.emptyList();
        }
    };

    public DamContext(@NotNull Asset asset, @NotNull MediaArgs mediaArgs, @NotNull MediaHandlerConfig mediaHandlerConfig, @NotNull DynamicMediaSupportService dynamicMediaSupportService, @NotNull WebOptimizedImageDeliveryService webOptimizedImageDeliveryService, @NotNull Adaptable adaptable) {
        this.asset = asset;
        this.mediaArgs = mediaArgs;
        this.mediaHandlerConfig = mediaHandlerConfig;
        this.dynamicMediaSupportService = dynamicMediaSupportService;
        this.webOptimizedImageDeliveryService = webOptimizedImageDeliveryService;
        this.adaptable = adaptable;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public MediaArgs getMediaArgs() {
        return this.mediaArgs;
    }

    public MediaHandlerConfig getMediaHandlerConfig() {
        return this.mediaHandlerConfig;
    }

    public boolean isDynamicMediaEnabled() {
        return this.dynamicMediaSupportService.isDynamicMediaEnabled() && this.dynamicMediaSupportService.isDynamicMediaCapabilityEnabled(this.isDynamicMediaAsset()) && !this.mediaArgs.isDynamicMediaDisabled();
    }

    public boolean isDynamicMediaAemFallbackDisabled() {
        return this.dynamicMediaSupportService.isAemFallbackDisabled();
    }

    @Nullable
    public String getDynamicMediaObject() {
        if (this.dynamicMediaObject == null) {
            this.dynamicMediaObject = this.asset.getMetadataValueFromJcr("dam:scene7File");
        }
        return this.dynamicMediaObject;
    }

    public boolean isDynamicMediaAsset() {
        return StringUtils.isNotBlank((CharSequence)this.getDynamicMediaObject());
    }

    @Nullable
    public String getDynamicMediaServerUrl() {
        if (this.dynamicMediaServerUrl == null) {
            this.dynamicMediaServerUrl = this.dynamicMediaSupportService.getDynamicMediaServerUrl(this.asset, this.mediaArgs.getUrlMode(), this.adaptable);
        }
        return this.dynamicMediaServerUrl;
    }

    public boolean isDynamicMediaValidateSmartCropRenditionSizes() {
        return this.dynamicMediaSupportService.isValidateSmartCropRenditionSizes();
    }

    @NotNull
    public Dimension getDynamicMediaImageSizeLimit() {
        if (this.dynamicMediaImageSizeLimit == null) {
            this.dynamicMediaImageSizeLimit = this.dynamicMediaSupportService.getImageSizeLimit();
        }
        return this.dynamicMediaImageSizeLimit;
    }

    @Nullable
    public ImageProfile getImageProfile() {
        if (this.imageProfile == null) {
            this.imageProfile = this.dynamicMediaSupportService.getImageProfileForAsset(this.asset);
            if (this.imageProfile == null) {
                this.imageProfile = NO_IMAGE_PROFILE;
            }
        }
        if (this.imageProfile == NO_IMAGE_PROFILE) {
            return null;
        }
        return this.imageProfile;
    }

    public boolean isWebOptimizedImageDeliveryEnabled() {
        return this.webOptimizedImageDeliveryService.isEnabled();
    }

    @Nullable
    public String getWebOptimizedImageDeliveryUrl(@NotNull WebOptimizedImageDeliveryParams params) {
        params.quality(ImageQualityPercentage.getAsInteger(this.mediaArgs, this.mediaHandlerConfig));
        return this.webOptimizedImageDeliveryService.getDeliveryUrl(this.asset, params);
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        if (this.adaptable instanceof Resource) {
            return ((Resource)this.adaptable).getResourceResolver();
        }
        if (this.adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)this.adaptable).getResourceResolver();
        }
        throw new IllegalStateException("Adaptable is neither Resoucre nor SlingHttpServletRequest");
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return (AdapterType)this.adaptable.adaptTo(type);
    }
}

