/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.mediasource.dam.impl.DamAutoCropping;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DefaultRenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.TransformedRenditionHandler;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.caching.ModificationDate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DamRendition
extends SlingAdaptable
implements Rendition {
    private final DamContext damContext;
    private final MediaArgs mediaArgs;
    private final RenditionMetadata rendition;
    private boolean fallback;
    private static final Logger log = LoggerFactory.getLogger(DamRendition.class);

    DamRendition(CropDimension cropDimension, Integer rotation, MediaArgs mediaArgs, DamContext damContext) {
        DefaultRenditionHandler renditionHandler;
        this.damContext = damContext;
        this.mediaArgs = mediaArgs;
        RenditionMetadata resolvedRendition = null;
        if (cropDimension == null && rotation == null) {
            renditionHandler = new DefaultRenditionHandler(damContext);
            resolvedRendition = renditionHandler.getRendition(mediaArgs);
        } else {
            renditionHandler = new TransformedRenditionHandler(cropDimension, rotation, damContext);
            resolvedRendition = renditionHandler.getRendition(mediaArgs);
            if (resolvedRendition == null && cropDimension != null) {
                if (rotation != null) {
                    renditionHandler = new TransformedRenditionHandler(null, rotation, damContext);
                    resolvedRendition = renditionHandler.getRendition(mediaArgs);
                } else {
                    renditionHandler = new DefaultRenditionHandler(damContext);
                    resolvedRendition = renditionHandler.getRendition(mediaArgs);
                }
                if (resolvedRendition != null) {
                    this.fallback = true;
                }
            }
        }
        if (resolvedRendition == null && mediaArgs.isAutoCrop()) {
            CropDimension autoCropDimension;
            TransformedRenditionHandler renditionHandler2;
            DamAutoCropping autoCropping = new DamAutoCropping(damContext, mediaArgs);
            List<CropDimension> autoCropDimensions = autoCropping.calculateAutoCropDimensions();
            Iterator<CropDimension> iterator = autoCropDimensions.iterator();
            while (iterator.hasNext() && (resolvedRendition = (renditionHandler2 = new TransformedRenditionHandler(autoCropDimension = iterator.next(), rotation, damContext)).getRendition(mediaArgs)) == null) {
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("DamRendition: resolvedRendition={}, mediaArgs={}, cropDimension={}, rotation={}", new Object[]{resolvedRendition, mediaArgs, cropDimension, rotation});
        }
        this.rendition = resolvedRendition;
    }

    @Override
    public String getUrl() {
        if (this.rendition == null) {
            return null;
        }
        String url = null;
        if (this.damContext.isDynamicMediaEnabled()) {
            if (this.damContext.isDynamicMediaAsset()) {
                url = this.buildDynamicMediaUrl();
                if (url == null) {
                    return null;
                }
            } else {
                if (this.damContext.isDynamicMediaAemFallbackDisabled()) {
                    log.warn("Asset is not a valid DM asset, fallback disabled, rendition invalid: {}", (Object)this.rendition.getRendition().getPath());
                    return null;
                }
                log.trace("Asset is not a valid DM asset, fallback to AEM-rendered rendition: {}", (Object)this.rendition.getRendition().getPath());
            }
        }
        if (url == null) {
            url = this.buildWebOptimizedImageDeliveryUrl();
        }
        if (url == null) {
            UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)this.damContext, UrlHandler.class);
            String mediaPath = this.rendition.getMediaPath(this.mediaArgs.isContentDispositionAttachment());
            url = urlHandler.get(mediaPath).urlMode(this.mediaArgs.getUrlMode()).buildExternalResourceUrl(this.rendition.adaptTo(Resource.class));
        }
        return url;
    }

    @Nullable
    private String buildDynamicMediaUrl() {
        String dynamicMediaPath = this.rendition.getDynamicMediaPath(this.mediaArgs.isContentDispositionAttachment(), this.damContext);
        String productionAssetUrl = this.damContext.getDynamicMediaServerUrl();
        if (dynamicMediaPath != null && productionAssetUrl != null) {
            return productionAssetUrl + dynamicMediaPath;
        }
        return null;
    }

    @Nullable
    private String buildWebOptimizedImageDeliveryUrl() {
        if (MediaFileType.isImage(this.getFileExtension()) && !MediaFileType.isVectorImage(this.getFileExtension()) && !this.mediaArgs.isContentDispositionAttachment() && !this.mediaArgs.isWebOptimizedImageDeliveryDisabled()) {
            return this.rendition.getWebOptimizedImageDeliveryPath(this.damContext);
        }
        return null;
    }

    @Override
    public String getPath() {
        if (this.rendition != null) {
            return this.rendition.getRendition().getPath();
        }
        return null;
    }

    @Override
    public String getFileName() {
        if (this.rendition != null) {
            return this.rendition.getFileName(this.mediaArgs.isContentDispositionAttachment());
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        return FilenameUtils.getExtension((String)this.getFileName());
    }

    @Override
    public long getFileSize() {
        if (this.rendition != null) {
            return this.rendition.getFileSize();
        }
        return 0L;
    }

    @Override
    public String getMimeType() {
        if (this.rendition != null) {
            return this.rendition.getMimeType();
        }
        return null;
    }

    @Override
    public Date getModificationDate() {
        if (this.rendition != null) {
            return ModificationDate.get((Resource)((Resource)this.rendition.getRendition().adaptTo(Resource.class)));
        }
        return null;
    }

    @Override
    public MediaFormat getMediaFormat() {
        if (this.rendition != null) {
            return this.rendition.getMediaFormat();
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public ValueMap getProperties() {
        if (this.rendition != null) {
            return ((Resource)this.rendition.getRendition().adaptTo(Resource.class)).getValueMap();
        }
        return ValueMap.EMPTY;
    }

    @Override
    public boolean isImage() {
        return MediaFileType.isImage(this.getFileExtension());
    }

    @Override
    public boolean isBrowserImage() {
        return MediaFileType.isBrowserImage(this.getFileExtension());
    }

    @Override
    public boolean isVectorImage() {
        return MediaFileType.isVectorImage(this.getFileExtension());
    }

    @Override
    public boolean isDownload() {
        return !this.isImage();
    }

    @Override
    public long getWidth() {
        if (this.rendition != null) {
            return this.rendition.getWidth();
        }
        return 0L;
    }

    @Override
    public long getHeight() {
        if (this.rendition != null) {
            return this.rendition.getHeight();
        }
        return 0L;
    }

    @Override
    public boolean isFallback() {
        return this.fallback;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        if (this.rendition == null) {
            throw new IllegalStateException("Rendition is not valid.");
        }
        if (type == UriTemplateType.CROP_CENTER) {
            throw new IllegalArgumentException("CROP_CENTER not supported for rendition URI templates.");
        }
        return this.rendition.getUriTemplate(type, this.damContext);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        AdapterType result;
        if (this.rendition != null && (result = this.rendition.adaptTo(type)) != null) {
            return result;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        if (this.rendition != null) {
            return this.rendition.toString();
        }
        return super.toString();
    }
}

