/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Rendition;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.media.impl.ImageFileServletSelector;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaPath;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.SmartCrop;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DamUriTemplate
implements UriTemplate {
    private static final long DUMMY_WIDTH = 999991L;
    private static final long DUMMY_HEIGHT = 999992L;
    private final UriTemplateType type;
    private final String uriTemplate;
    private final Dimension dimension;

    DamUriTemplate(@NotNull UriTemplateType type, @NotNull Dimension dimension, @NotNull Rendition rendition, @Nullable CropDimension cropDimension, @Nullable Integer rotation, @Nullable Double ratio, @NotNull DamContext damContext) {
        NamedDimension smartCropDef;
        this.type = type;
        String url = null;
        Dimension validatedDimension = null;
        if (damContext.isDynamicMediaEnabled() && damContext.isDynamicMediaAsset() && (url = DamUriTemplate.buildUriTemplateDynamicMedia(type, cropDimension, rotation, smartCropDef = DamUriTemplate.getDynamicMediaSmartCropDef(cropDimension, rotation, ratio, damContext), damContext)) != null && smartCropDef != null) {
            validatedDimension = SmartCrop.getCropDimensionForAsset(damContext.getAsset(), damContext.getResourceResolver(), smartCropDef);
        }
        if (!(url != null || damContext.isDynamicMediaEnabled() && damContext.isDynamicMediaAemFallbackDisabled())) {
            if (damContext.isWebOptimizedImageDeliveryEnabled()) {
                url = DamUriTemplate.buildUriTemplateWebOptimizedImageDelivery(type, cropDimension, rotation, damContext);
            }
            if (url == null) {
                url = DamUriTemplate.buildUriTemplateDam(type, rendition, cropDimension, rotation, damContext.getMediaArgs().getImageQualityPercentage(), damContext);
            }
        }
        this.uriTemplate = url;
        if (validatedDimension == null) {
            validatedDimension = dimension;
        }
        this.dimension = validatedDimension;
    }

    private static String buildUriTemplateDam(@NotNull UriTemplateType type, @NotNull Rendition rendition, @Nullable CropDimension cropDimension, @Nullable Integer rotation, @Nullable Double imageQualityPercentage, @NotNull DamContext damContext) {
        MediaArgs mediaArgs = damContext.getMediaArgs();
        String mediaPath = RenditionMetadata.buildMediaPath(rendition.getPath() + "." + ImageFileServletSelector.build(999991L, 999992L, cropDimension, rotation, imageQualityPercentage, false) + ".file", ImageFileServlet.getImageFileName(damContext.getAsset().getName(), mediaArgs.getEnforceOutputFileExtension()));
        UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)damContext, UrlHandler.class);
        String url = urlHandler.get(mediaPath).urlMode(mediaArgs.getUrlMode()).buildExternalResourceUrl((Resource)damContext.getAsset().adaptTo(Resource.class));
        switch (type) {
            case CROP_CENTER: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                break;
            }
            case SCALE_WIDTH: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"0");
                break;
            }
            case SCALE_HEIGHT: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"0");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
        }
        return url;
    }

    private static String buildUriTemplateWebOptimizedImageDelivery(@NotNull UriTemplateType type, @Nullable CropDimension cropDimension, @Nullable Integer rotation, @NotNull DamContext damContext) {
        if (type == UriTemplateType.SCALE_HEIGHT) {
            return null;
        }
        String url = damContext.getWebOptimizedImageDeliveryUrl(new WebOptimizedImageDeliveryParams().width(999991L).cropDimension(cropDimension).rotation(rotation));
        if (url == null) {
            return null;
        }
        switch (type) {
            case CROP_CENTER: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                break;
            }
            case SCALE_WIDTH: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type for Web-optimized image delivery: " + type);
            }
        }
        return url;
    }

    @Nullable
    private static String buildUriTemplateDynamicMedia(@NotNull UriTemplateType type, @Nullable CropDimension cropDimension, @Nullable Integer rotation, @Nullable NamedDimension smartCropDef, @NotNull DamContext damContext) {
        String productionAssetUrl = damContext.getDynamicMediaServerUrl();
        if (productionAssetUrl == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append(productionAssetUrl).append(DynamicMediaPath.buildImage(damContext));
        if (smartCropDef != null) {
            result.append("%3A").append(smartCropDef.getName()).append("?").append(DamUriTemplate.getDynamicMediaWidthHeightParameters(type)).append("&fit=constrain");
            return result.toString();
        }
        result.append("?");
        if (cropDimension != null) {
            result.append("crop=").append(cropDimension.getCropStringWidthHeight()).append("&");
        }
        if (rotation != null) {
            result.append("rotate=").append(rotation).append("&");
        }
        result.append(DamUriTemplate.getDynamicMediaWidthHeightParameters(type));
        return result.toString();
    }

    private static String getDynamicMediaWidthHeightParameters(UriTemplateType type) {
        switch (type) {
            case CROP_CENTER: {
                return "wid={width}&hei={height}&fit=crop";
            }
            case SCALE_WIDTH: {
                return "wid={width}";
            }
            case SCALE_HEIGHT: {
                return "hei={height}";
            }
        }
        throw new IllegalArgumentException("Unsupported type for Dynamic Media: " + type);
    }

    private static NamedDimension getDynamicMediaSmartCropDef(@Nullable CropDimension cropDimension, @Nullable Integer rotation, @Nullable Double ratio, @NotNull DamContext damContext) {
        if (SmartCrop.canApply(cropDimension, rotation) && ratio != null) {
            return SmartCrop.getDimensionForRatio(damContext.getImageProfile(), ratio);
        }
        return null;
    }

    @Override
    @NotNull
    public UriTemplateType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public long getMaxWidth() {
        return this.dimension.getWidth();
    }

    @Override
    public long getMaxHeight() {
        return this.dimension.getHeight();
    }

    public String toString() {
        return this.uriTemplate;
    }
}

