/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Rendition;
import com.day.image.Layer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DamUriTemplate;
import io.wcm.handler.mediasource.dam.impl.VirtualTransformedRenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaPath;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RenditionMetadata
extends SlingAdaptable
implements Comparable<RenditionMetadata> {
    private final Rendition rendition;
    private final String fileName;
    private final String fileExtension;
    private LazyValue<Dimension> dimensionLazyValue;
    private final boolean isImage;
    private final boolean isVectorImage;
    private MediaFormat mediaFormat;

    RenditionMetadata(final Rendition rendition) {
        this.rendition = rendition;
        this.fileName = AssetRendition.getFilename(rendition);
        this.fileExtension = FilenameUtils.getExtension((String)this.fileName);
        this.isImage = MediaFileType.isImage(this.fileExtension);
        this.isVectorImage = MediaFileType.isVectorImage(this.fileExtension);
        this.dimensionLazyValue = new LazyValue<Dimension>(){

            protected Dimension createValue() {
                Dimension result = AssetRendition.getDimension(rendition);
                if (result == null) {
                    result = new Dimension(0L, 0L);
                }
                return result;
            }
        };
    }

    public boolean isImage() {
        return this.isImage;
    }

    public boolean isVectorImage() {
        return this.isVectorImage;
    }

    public Rendition getRendition() {
        return this.rendition;
    }

    public String getFileName(boolean contentDispositionAttachment) {
        if (MediaFileType.isBrowserImage(this.getFileExtension()) || !MediaFileType.isImage(this.getFileExtension()) || contentDispositionAttachment || this.isVectorImage()) {
            return this.fileName;
        }
        return ImageFileServlet.getImageFileName(this.fileName);
    }

    public long getFileSize() {
        return this.rendition.getSize();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMimeType() {
        return this.rendition.getMimeType();
    }

    public long getWidth() {
        return ((Dimension)this.dimensionLazyValue.get()).getWidth();
    }

    public long getHeight() {
        return ((Dimension)this.dimensionLazyValue.get()).getHeight();
    }

    public MediaFormat getMediaFormat() {
        return this.mediaFormat;
    }

    public void setMediaFormat(MediaFormat mediaFormat) {
        this.mediaFormat = mediaFormat;
    }

    @NotNull
    public String getMediaPath(boolean contentDispositionAttachment) {
        if (contentDispositionAttachment) {
            return RenditionMetadata.buildMediaPath(this.getRendition().getPath() + ".media_file.download_attachment.file", this.getFileName(contentDispositionAttachment));
        }
        if (MediaFileType.isVectorImage(this.getFileExtension())) {
            return RenditionMetadata.buildMediaPath(this.getRendition().getPath() + ".media_file.file", this.getFileName(contentDispositionAttachment));
        }
        if (MediaFileType.isBrowserImage(this.getFileExtension()) || !MediaFileType.isImage(this.getFileExtension())) {
            return RenditionMetadata.buildMediaPath(this.rendition.getPath() + ".", this.getFileName(contentDispositionAttachment));
        }
        return RenditionMetadata.buildMediaPath(this.getRendition().getPath() + ".image_file." + this.getWidth() + "." + this.getHeight() + ".file", this.getFileName(contentDispositionAttachment));
    }

    @Nullable
    public String getDynamicMediaPath(boolean contentDispositionAttachment, DamContext damContext) {
        if (contentDispositionAttachment) {
            return DynamicMediaPath.buildContent(damContext, true);
        }
        if (MediaFileType.isBrowserImage(this.getFileExtension()) && (MediaFileType.isVectorImage(this.getFileExtension()) || StringUtils.equals((CharSequence)this.getFileExtension(), (CharSequence)"gif")) || !MediaFileType.isImage(this.getFileExtension())) {
            return DynamicMediaPath.buildContent(damContext, false);
        }
        return DynamicMediaPath.buildImage(damContext, this.getWidth(), this.getHeight());
    }

    @Nullable
    public String getWebOptimizedImageDeliveryPath(DamContext damContext) {
        return damContext.getWebOptimizedImageDeliveryUrl(new WebOptimizedImageDeliveryParams());
    }

    public boolean matches(long checkWidth, long checkHeight) {
        if (checkWidth != 0L && checkWidth != this.getWidth()) {
            return false;
        }
        return checkHeight == 0L || checkHeight == this.getHeight();
    }

    public boolean matches(long minWidth, long minHeight, long maxWidth, long maxHeight, long minWidthHeight, double ratio) {
        double renditionRatio;
        if (minWidthHeight > 0L && this.getWidth() < minWidthHeight && this.getHeight() < minWidthHeight) {
            return false;
        }
        if (minWidth > 0L && this.getWidth() < minWidth) {
            return false;
        }
        if (minHeight > 0L && this.getHeight() < minHeight) {
            return false;
        }
        if (maxWidth > 0L && this.getWidth() > maxWidth) {
            return false;
        }
        if (maxHeight > 0L && this.getHeight() > maxHeight) {
            return false;
        }
        return !(ratio > 0.0) || Ratio.matches(renditionRatio = Ratio.get(this.getWidth(), this.getHeight()), ratio);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.rendition.getPath()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RenditionMetadata other = (RenditionMetadata)obj;
        return new EqualsBuilder().append((Object)this.rendition.getPath(), (Object)other.rendition.getPath()).build();
    }

    @Override
    public int compareTo(RenditionMetadata obj) {
        Long otherWidth;
        boolean thisIsVirtualRendition = this instanceof VirtualTransformedRenditionMetadata;
        boolean otherIsVirtualRendition = obj instanceof VirtualTransformedRenditionMetadata;
        if (thisIsVirtualRendition && !otherIsVirtualRendition) {
            return -2;
        }
        if (otherIsVirtualRendition && !thisIsVirtualRendition) {
            return 2;
        }
        boolean thisIsOriginalRendition = AssetRendition.isOriginal(this.getRendition());
        boolean otherIsOriginalRendition = AssetRendition.isOriginal(obj.getRendition());
        if (thisIsOriginalRendition && !otherIsOriginalRendition) {
            return -1;
        }
        if (otherIsOriginalRendition && !thisIsOriginalRendition) {
            return 1;
        }
        Long thisWidth = this.getWidth();
        if (thisWidth.equals(otherWidth = Long.valueOf(obj.getWidth()))) {
            Long otherHeight;
            Long thisHeight = this.getHeight();
            if (thisHeight.equals(otherHeight = Long.valueOf(obj.getHeight()))) {
                String otherPath;
                String thisPath = this.getRendition().getPath();
                if (!StringUtils.equals((CharSequence)thisPath, (CharSequence)(otherPath = obj.getRendition().getPath()))) {
                    return thisPath.compareTo(otherPath);
                }
                return 0;
            }
            return thisHeight.compareTo(otherHeight);
        }
        return thisWidth.compareTo(otherWidth);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected Layer getLayer() {
        if (MediaFileType.isImage(this.getFileExtension())) {
            return (Layer)((Resource)this.rendition.adaptTo(Resource.class)).adaptTo(Layer.class);
        }
        return null;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected InputStream getInputStream() {
        return (InputStream)((Resource)this.rendition.adaptTo(Resource.class)).adaptTo(InputStream.class);
    }

    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type, @NotNull DamContext damContext) {
        if (!this.isImage() || this.isVectorImage()) {
            throw new UnsupportedOperationException("Unable to build URI template for rendition: " + this.getRendition().getPath());
        }
        Dimension dimension = AssetRendition.getDimension(this.getRendition());
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to get dimension for rendition: " + this.getRendition().getPath());
        }
        return new DamUriTemplate(type, dimension, this.rendition, null, null, Ratio.get(dimension), damContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rendition.getPath());
        if (this.getWidth() > 0L || this.getHeight() > 0L) {
            sb.append(" (").append(Long.toString(this.getWidth())).append("x").append(Long.toString(this.getHeight())).append(")");
        }
        return sb.toString();
    }

    static String buildMediaPath(String mediaPath, String suffix) {
        return mediaPath + "/" + suffix;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Rendition.class) {
            return (AdapterType)this.rendition;
        }
        if (type == Resource.class) {
            return (AdapterType)this.rendition.adaptTo(Resource.class);
        }
        if (type == Layer.class) {
            return (AdapterType)this.getLayer();
        }
        if (type == InputStream.class) {
            return (AdapterType)this.getInputStream();
        }
        return (AdapterType)super.adaptTo(type);
    }

    @Deprecated(since="2.0.0")
    protected final void finalize() {
    }
}

