/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.SmartCrop;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicMediaPath {
    private static final String IMAGE_SERVER_PATH = "/is/image/";
    private static final String CONTENT_SERVER_PATH = "/is/content/";
    public static final String DOWNLOAD_SUFFIX = "?cdh=attachment";
    private static final Logger log = LoggerFactory.getLogger(DynamicMediaPath.class);

    private DynamicMediaPath() {
    }

    @NotNull
    public static String buildContent(@NotNull DamContext damContext, boolean contentDispositionAttachment) {
        StringBuilder result = new StringBuilder();
        result.append(CONTENT_SERVER_PATH).append(DynamicMediaPath.encodeDynamicMediaObject(damContext));
        if (contentDispositionAttachment) {
            result.append(DOWNLOAD_SUFFIX);
        }
        return result.toString();
    }

    @NotNull
    public static String buildImage(@NotNull DamContext damContext) {
        return IMAGE_SERVER_PATH + DynamicMediaPath.encodeDynamicMediaObject(damContext);
    }

    @Nullable
    public static String buildImage(@NotNull DamContext damContext, long width, long height) {
        return DynamicMediaPath.buildImage(damContext, width, height, null, null);
    }

    @Nullable
    public static String buildImage(@NotNull DamContext damContext, long width, long height, @Nullable CropDimension cropDimension, @Nullable Integer rotation) {
        NamedDimension smartCropDef;
        Dimension dimension = DynamicMediaPath.calcWidthHeight(damContext, width, height);
        StringBuilder result = new StringBuilder();
        result.append(IMAGE_SERVER_PATH).append(DynamicMediaPath.encodeDynamicMediaObject(damContext));
        if (SmartCrop.canApply(cropDimension, rotation) && (smartCropDef = SmartCrop.getDimensionForWidthHeight(damContext.getImageProfile(), width, height)) != null) {
            if (damContext.isDynamicMediaValidateSmartCropRenditionSizes() && !SmartCrop.isMatchingSize(damContext.getAsset(), damContext.getResourceResolver(), smartCropDef, width, height)) {
                DynamicMediaPath.logResult(damContext, "<too small for " + width + "x" + height + ">");
                return null;
            }
            result.append("%3A").append(smartCropDef.getName()).append("?").append("wid=").append(dimension.getWidth()).append("&").append("hei=").append(dimension.getHeight()).append("&").append("fit=stretch");
            DynamicMediaPath.logResult(damContext, result);
            return result.toString();
        }
        result.append("?");
        if (cropDimension != null) {
            result.append("crop=").append(cropDimension.getCropStringWidthHeight()).append("&");
        }
        if (rotation != null) {
            result.append("rotate=").append(rotation).append("&");
        }
        result.append("wid=").append(dimension.getWidth()).append("&").append("hei=").append(dimension.getHeight()).append("&").append("fit=stretch");
        DynamicMediaPath.logResult(damContext, result);
        return result.toString();
    }

    private static void logResult(@NotNull DamContext damContext, @NotNull CharSequence result) {
        if (log.isTraceEnabled()) {
            log.trace("Build dynamic media path for {}: {}", (Object)damContext.getAsset().getPath(), (Object)result);
        }
    }

    private static Dimension calcWidthHeight(@NotNull DamContext damContext, long width, long height) {
        Dimension sizeLimit = damContext.getDynamicMediaImageSizeLimit();
        if (width > sizeLimit.getWidth()) {
            double ratio = Ratio.get(width, height);
            long newWidth = sizeLimit.getWidth();
            long newHeight = Math.round((double)newWidth / ratio);
            return DynamicMediaPath.calcWidthHeight(damContext, newWidth, newHeight);
        }
        if (height > sizeLimit.getHeight()) {
            double ratio = Ratio.get(width, height);
            long newHeight = sizeLimit.getHeight();
            long newWidth = Math.round((double)newHeight * ratio);
            return new Dimension(newWidth, newHeight);
        }
        return new Dimension(width, height);
    }

    private static String encodeDynamicMediaObject(@NotNull DamContext damContext) {
        Object[] pathParts = StringUtils.split((String)damContext.getDynamicMediaObject(), (String)"/");
        for (int i = 0; i < pathParts.length; ++i) {
            pathParts[i] = URLEncoder.encode((String)pathParts[i], StandardCharsets.UTF_8);
            pathParts[i] = StringUtils.replace((String)pathParts[i], (String)"+", (String)"%20");
        }
        return StringUtils.join((Object[])pathParts, (String)"/");
    }
}

