/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.utils.PublishUtils;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaCapabilityDetection;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfileImpl;
import io.wcm.handler.url.SiteConfig;
import io.wcm.handler.url.UrlHandler;
import io.wcm.handler.url.UrlMode;
import io.wcm.handler.url.UrlModes;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DynamicMediaSupportService.class}, immediate=true)
@Designate(ocd=Config.class)
public class DynamicMediaSupportServiceImpl
implements DynamicMediaSupportService {
    @Reference
    private PublishUtils dynamicMediaPublishUtils;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private boolean enabled;
    private DynamicMediaCapabilityDetection dmCapabilityDetection;
    private boolean authorPreviewMode;
    private boolean disableAemFallback;
    private boolean validateSmartCropRenditionSizes;
    private Dimension imageSizeLimit;
    private static final String SERVICEUSER_SUBSERVICE = "dynamic-media-support";
    private static final Pattern DAM_PATH_PATTERN = Pattern.compile("^/content/dam(/.*)?$");
    private static final Logger log = LoggerFactory.getLogger(DynamicMediaSupportServiceImpl.class);

    @Activate
    private void activate(Config config) {
        this.enabled = config.enabled();
        this.dmCapabilityDetection = config.dmCapabilityDetection();
        this.authorPreviewMode = config.authorPreviewMode();
        this.disableAemFallback = config.disableAemFallback();
        this.validateSmartCropRenditionSizes = config.validateSmartCropRenditionSizes();
        this.imageSizeLimit = new Dimension(config.imageSizeLimitWidth(), config.imageSizeLimitHeight());
        if (this.enabled) {
            log.info("DynamicMediaSupport: enabled={}, capabilityEnabled={}, capabilityDetection={}, authorPreviewMode={}, disableAemFallback={}, imageSizeLimit={}", new Object[]{this.enabled, this.dmCapabilityDetection, this.dmCapabilityDetection, this.authorPreviewMode, this.disableAemFallback, this.imageSizeLimit});
        }
    }

    @Override
    public boolean isDynamicMediaEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isDynamicMediaCapabilityEnabled(boolean isDynamicMediaAsset) {
        switch (this.dmCapabilityDetection) {
            case AUTO: {
                return isDynamicMediaAsset;
            }
            case ON: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAemFallbackDisabled() {
        return this.disableAemFallback;
    }

    @Override
    public boolean isValidateSmartCropRenditionSizes() {
        return this.validateSmartCropRenditionSizes;
    }

    @Override
    @NotNull
    public Dimension getImageSizeLimit() {
        return this.imageSizeLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ImageProfile getImageProfile(@NotNull String profilePath) {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Map.of("sling.service.subservice", SERVICEUSER_SUBSERVICE));){
            Resource profileResource = resourceResolver.getResource(profilePath);
            if (profileResource != null) {
                log.debug("Loaded image profile: {}", (Object)profilePath);
                ImageProfileImpl imageProfileImpl = new ImageProfileImpl(profileResource);
                return imageProfileImpl;
            }
        }
        catch (LoginException ex) {
            log.error("Missing service user mapping for 'io.wcm.handler.media:dynamic-media-support' - see https://wcm.io/handler/media/configuration.html", (Throwable)ex);
        }
        log.debug("Image profile not found: {}", (Object)profilePath);
        return null;
    }

    @Override
    @Nullable
    public ImageProfile getImageProfileForAsset(@NotNull Asset asset) {
        Resource assetResource = (Resource)AdaptTo.notNull((Adaptable)asset, Resource.class);
        Resource folderResource = assetResource.getParent();
        if (folderResource != null) {
            return this.getImageProfileForAssetFolder(folderResource);
        }
        return null;
    }

    @Nullable
    private ImageProfile getImageProfileForAssetFolder(@NotNull Resource folderResource) {
        String imageProfilePath;
        if (!DAM_PATH_PATTERN.matcher(folderResource.getPath()).matches()) {
            return null;
        }
        Resource folderContentResource = folderResource.getChild("jcr:content");
        if (folderContentResource != null && (imageProfilePath = (String)folderContentResource.getValueMap().get("imageProfile", String.class)) != null) {
            return this.getImageProfile(imageProfilePath);
        }
        Resource parentFolderResource = folderResource.getParent();
        if (parentFolderResource != null) {
            return this.getImageProfileForAssetFolder(parentFolderResource);
        }
        return null;
    }

    @Override
    @Nullable
    public String getDynamicMediaServerUrl(@NotNull Asset asset, @Nullable UrlMode urlMode, @NotNull Adaptable adaptable) {
        Resource assetResource = (Resource)AdaptTo.notNull((Adaptable)asset, Resource.class);
        if (this.authorPreviewMode && !this.forcePublishMode(urlMode)) {
            SiteConfig siteConfig = (SiteConfig)AdaptTo.notNull((Adaptable)adaptable, SiteConfig.class);
            String siteUrlAUthor = StringUtils.defaultString((String)siteConfig.siteUrlAuthor());
            UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)adaptable, UrlHandler.class);
            return urlHandler.applySiteUrlAutoDetection(siteUrlAUthor);
        }
        try {
            String[] productionAssetUrls = this.dynamicMediaPublishUtils.externalizeImageDeliveryAsset(assetResource);
            if (productionAssetUrls != null && productionAssetUrls.length > 0) {
                return productionAssetUrls[0];
            }
        }
        catch (RepositoryException ex) {
            log.warn("Unable to get dynamic media production asset URLs for {}", (Object)assetResource.getPath(), (Object)ex);
        }
        log.warn("Unable to get dynamic media production asset URLs for {}", (Object)assetResource.getPath());
        return null;
    }

    private boolean forcePublishMode(@Nullable UrlMode urlMode) {
        return urlMode != null && (urlMode.equals(UrlModes.FULL_URL_PUBLISH) || urlMode.equals(UrlModes.FULL_URL_PUBLISH_FORCENONSECURE) || urlMode.equals(UrlModes.FULL_URL_PUBLISH_FORCESECURE) || urlMode.equals(UrlModes.FULL_URL_PUBLISH_PROTOCOLRELATIVE));
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Dynamic Media Support", description="Configures dynamic media support in media handling.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable support for dynamic media. Only gets active when dynamic media is actually enabled for the instance.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Dynamic Media Capability", description="Whether to detect automatically if Dynamic Media is actually for a given asset by looking for existing DM metadata. Setting to ON disables the auto-detection and forces it to enabled for all asssets, setting to OFF forced it to disabled.")
        public DynamicMediaCapabilityDetection dmCapabilityDetection() default DynamicMediaCapabilityDetection.AUTO;

        @AttributeDefinition(name="Author Preview Mode", description="Loads dynamic media images via author instance - to allow previewing unpublished images. Must not be enabled on publish instances.")
        public boolean authorPreviewMode() default false;

        @AttributeDefinition(name="Disable AEM Fallback", description="Disable the automatic fallback to AEM-based rendering of renditions (via Media Handler) if Dynamic Media is enabled, but the asset has not the appropriate Dynamic Media metadata.")
        public boolean disableAemFallback() default false;

        @AttributeDefinition(name="Validte Smart Crop Rendition Sizes", description="Validates that the renditions defined via smart cropping fulfill the requested image width/height to avoid upscaling or white borders.")
        public boolean validateSmartCropRenditionSizes() default true;

        @AttributeDefinition(name="Image width limit", description="The configured width value for 'Reply Image Size Limit'.")
        public long imageSizeLimitWidth() default 2000L;

        @AttributeDefinition(name="Image height limit", description="The configured height value for 'Reply Image Size Limit'.")
        public long imageSizeLimitHeight() default 2000L;
    }
}

