/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.image.Layer;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.impl.ResourceLayerUtil;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenditionMetadataGenerator {
    private final ResourceResolver resourceResolver;
    private final AssetStore assetStore;
    private static final Logger log = LoggerFactory.getLogger(RenditionMetadataGenerator.class);

    public RenditionMetadataGenerator(ResourceResolver resourceResolver, AssetStore assetStore) {
        this.resourceResolver = resourceResolver;
        this.assetStore = assetStore;
    }

    public void processAllRenditions(Asset asset) {
        HashSet<String> existingRenditionNames = new HashSet<String>();
        ArrayList<String> renditionPaths = new ArrayList<String>();
        int addUpdateCount = 0;
        int removeCount = 0;
        int errorCount = 0;
        for (Rendition rendition : asset.getRenditions()) {
            existingRenditionNames.add(rendition.getName());
            renditionPaths.add(rendition.getPath());
        }
        HashSet<String> existingMetadataRenditionNames = new HashSet<String>();
        Resource metadataResource = this.resourceResolver.getResource(asset.getPath() + "/jcr:content/renditionsMetadata");
        if (metadataResource != null) {
            for (Resource metadataItem : metadataResource.getChildren()) {
                existingMetadataRenditionNames.add(metadataItem.getName());
            }
        }
        for (String renditionPath : renditionPaths) {
            try {
                if (!this.renditionAddedOrUpdated(renditionPath)) continue;
                ++addUpdateCount;
            }
            catch (PersistenceException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                ++errorCount;
            }
        }
        existingMetadataRenditionNames.removeAll(existingRenditionNames);
        for (String obsoleteRenditionName : existingMetadataRenditionNames) {
            String nonexistingRenditionPath = asset.getPath() + "/jcr:content/renditions/" + obsoleteRenditionName;
            try {
                if (!this.renditionRemoved(nonexistingRenditionPath)) continue;
                ++removeCount;
            }
            catch (PersistenceException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                ++errorCount;
            }
        }
        log.info("Processed rendition metadata for {}, {} added/updated, {} removed, {} error(s)", new Object[]{asset.getPath(), addUpdateCount, removeCount, errorCount});
    }

    public boolean renditionAddedOrUpdated(String renditionPath) throws PersistenceException {
        boolean metadataOutdated;
        Resource renditionResource = this.resourceResolver.getResource(renditionPath);
        if (renditionResource == null) {
            log.debug("Skip generation of metadata for non-existing rendition {}", (Object)renditionPath);
            return false;
        }
        boolean isOriginal = StringUtils.equals((CharSequence)ResourceUtil.getName((String)renditionPath), (CharSequence)"original");
        if (isOriginal) {
            boolean isSVG = StringUtils.equals((CharSequence)this.getContentType(renditionResource), (CharSequence)"image/svg+xml");
            if (!isSVG) {
                log.debug("Skip original rendition {}", (Object)renditionPath);
                return false;
            }
        } else {
            String fileExtension = FilenameUtils.getExtension((String)renditionPath);
            if (!MediaFileType.isImage(fileExtension)) {
                log.debug("Skip non-image rendition {}", (Object)renditionPath);
                return false;
            }
        }
        Calendar renditionTimestamp = this.getLastModified(renditionResource);
        String metdataResourcePath = this.getRenditionMetadataResourcePath(renditionPath);
        Resource metadataResource = this.resourceResolver.getResource(metdataResourcePath);
        Calendar renditionsMetadataTimestamp = this.getLastModified(metadataResource);
        boolean bl = metadataOutdated = renditionTimestamp == null || renditionsMetadataTimestamp == null || renditionsMetadataTimestamp.before(renditionTimestamp);
        if (!metadataOutdated) {
            log.debug("Skip re-generation of metadata for unchanged rendition {}", (Object)renditionPath);
            return false;
        }
        long startTime = System.currentTimeMillis();
        Dimension dimension = this.getRenditionDimension(renditionResource);
        long conversionDuration = System.currentTimeMillis() - startTime;
        if (dimension == null) {
            log.debug("Unable to calculate dimension of rendition {}", (Object)renditionPath);
            return false;
        }
        try {
            log.debug("Update rendition metadata at {} (width={}, height={}); duration={}ms.", new Object[]{metdataResourcePath, dimension.getWidth(), dimension.getHeight(), conversionDuration});
            if (metadataResource == null) {
                metadataResource = ResourceUtil.getOrCreateResource((ResourceResolver)this.resourceResolver, (String)metdataResourcePath, Map.of("jcr:primaryType", "nt:unstructured"), null, (boolean)false);
            }
            ModifiableValueMap props = (ModifiableValueMap)AdaptTo.notNull((Adaptable)metadataResource, ModifiableValueMap.class);
            props.put((Object)"imageWidth", (Object)dimension.getWidth());
            props.put((Object)"imageHeight", (Object)dimension.getHeight());
            props.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
            props.put((Object)"jcr:lastModifiedBy", (Object)this.resourceResolver.getUserID());
            this.resourceResolver.commit();
            return true;
        }
        catch (PersistenceException ex) {
            throw new PersistenceException("Unable to create or update rendition metadata node for " + renditionPath, (Throwable)ex);
        }
    }

    @Nullable
    private String getContentType(@NotNull Resource renditionResource) {
        return (String)renditionResource.getValueMap().get("jcr:content/jcr:mimeType", String.class);
    }

    private Calendar getLastModified(@Nullable Resource resource) {
        Calendar lastModified = null;
        if (resource != null) {
            Resource contentResource = resource.getChild("jcr:content");
            if (contentResource != null) {
                lastModified = (Calendar)contentResource.getValueMap().get("jcr:lastModified", Calendar.class);
            }
            if (lastModified == null) {
                lastModified = (Calendar)resource.getValueMap().get("jcr:lastModified", Calendar.class);
            }
            if (lastModified == null) {
                lastModified = (Calendar)resource.getValueMap().get("jcr:created", Calendar.class);
            }
        }
        return lastModified;
    }

    public boolean renditionRemoved(String renditionPath) throws PersistenceException {
        Resource renditionResource = this.resourceResolver.getResource(renditionPath);
        if (renditionResource != null) {
            log.debug("Skip removing of metadata for existing rendition {}", (Object)renditionPath);
            return false;
        }
        String metdataResourcePath = this.getRenditionMetadataResourcePath(renditionPath);
        Resource metadataResource = this.resourceResolver.getResource(metdataResourcePath);
        if (metadataResource == null) {
            return false;
        }
        try {
            log.debug("Remove rendition metadata at {}.", (Object)metadataResource.getPath());
            this.resourceResolver.delete(metadataResource);
            this.resourceResolver.commit();
            return true;
        }
        catch (PersistenceException ex) {
            throw new PersistenceException("Unable to delete rendition metadata node for " + renditionPath, (Throwable)ex);
        }
    }

    private Dimension getRenditionDimension(Resource renditionResource) {
        Layer layer = ResourceLayerUtil.toLayer(renditionResource, this.assetStore);
        if (layer == null) {
            return null;
        }
        return new Dimension(layer.getWidth(), layer.getHeight());
    }

    private String getRenditionMetadataResourcePath(String renditionPath) {
        String assetPath = StringUtils.substringBefore((String)renditionPath, (String)"/jcr:content/renditions/");
        String renditionName = Text.getName((String)renditionPath);
        return assetPath + "/jcr:content/renditionsMetadata/" + renditionName;
    }
}

