/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata;

import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.handler.store.AssetStore;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.mediasource.dam.impl.metadata.AssetSynchonizationService;
import io.wcm.handler.mediasource.dam.impl.metadata.RenditionMetadataGenerator;
import io.wcm.handler.mediasource.dam.impl.metadata.concurrency.NamedThreadFactory;
import io.wcm.wcm.commons.instancetype.InstanceTypeService;
import io.wcm.wcm.commons.util.RunMode;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventHandler.class}, immediate=true, configurationPid={"io.wcm.handler.mediasource.dam.impl.DamRenditionMetadataService"}, property={"event.topics=com/day/cq/dam"})
@Designate(ocd=Config.class)
public final class RenditionMetadataListenerService
implements EventHandler {
    private static final int REMOVE_EVENT_EXECUTION_DELAY_SECONDS = 10;
    private static final int MAX_RETRY_COUNT = 3;
    private static final int RETRY_DELAY_SECONDS = 5;
    private static final String SERVICEUSER_SUBSERVICE = "dam-rendition-metadata";
    private static final EnumSet<DamEvent.Type> SUPPORTED_EVENT_TYPES = EnumSet.of(DamEvent.Type.RENDITION_UPDATED, DamEvent.Type.RENDITION_REMOVED);
    private static final Logger log = LoggerFactory.getLogger(RenditionMetadataListenerService.class);
    private boolean enabled;
    private boolean synchronousProcessing;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private InstanceTypeService instanceTypeService;
    @Reference
    private AssetSynchonizationService assetSynchronizationService;
    @Reference
    private AssetStore assetStore;
    private ScheduledExecutorService executorService;

    @Activate
    private void activate(ComponentContext componentContext, Config config) {
        this.enabled = config.enabled() ? (config.allowedRunMode() != null && config.allowedRunMode().length > 0 ? !RunMode.disableIfNoRunModeActive((Set)this.instanceTypeService.getRunModes(), (String[])config.allowedRunMode(), (ComponentContext)componentContext, (Logger)log) : true) : false;
        boolean bl = this.synchronousProcessing = config.threadPoolSize() <= 0;
        if (this.enabled && !this.synchronousProcessing) {
            this.executorService = Executors.newScheduledThreadPool(config.threadPoolSize(), new NamedThreadFactory(this.getClass().getSimpleName()));
        }
    }

    @Deactivate
    private void deactivate() throws InterruptedException {
        this.enabled = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            this.executorService = null;
        }
    }

    public void handleEvent(Event event) {
        if (!this.enabled || !StringUtils.equals((CharSequence)event.getTopic(), (CharSequence)"com/day/cq/dam")) {
            return;
        }
        DamEvent damEvent = DamEvent.fromEvent((Event)event);
        if (SUPPORTED_EVENT_TYPES.contains(damEvent.getType())) {
            this.handleDamEvent(damEvent);
        }
    }

    private void handleDamEvent(DamEvent event) {
        String renditionPath = event.getAdditionalInfo();
        String renditionNodeName = Text.getName((String)renditionPath);
        boolean isOriginal = StringUtils.equals((CharSequence)renditionNodeName, (CharSequence)"original");
        String fileExtension = FilenameUtils.getExtension((String)renditionNodeName);
        if (!isOriginal && !MediaFileType.isImage(fileExtension)) {
            return;
        }
        RenditionMetadataEvent runnable = new RenditionMetadataEvent(event.getAssetPath(), renditionPath, event.getType());
        if (this.synchronousProcessing) {
            runnable.run();
        } else {
            this.executorService.schedule(runnable, (long)runnable.getDelaySeconds(), TimeUnit.SECONDS);
        }
    }

    private final class RenditionMetadataEvent
    implements Runnable {
        private final String assetPath;
        private final String renditionPath;
        private final DamEvent.Type eventType;
        private int retryCount;

        RenditionMetadataEvent(String assetPath, String renditionPath, DamEvent.Type eventType) {
            this.assetPath = assetPath;
            this.renditionPath = renditionPath;
            this.eventType = eventType;
        }

        private int getDelaySeconds() {
            if (this.eventType == DamEvent.Type.RENDITION_REMOVED) {
                return 10;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock lock = RenditionMetadataListenerService.this.assetSynchronizationService.getLock(this.assetPath);
            lock.lock();
            ResourceResolver serviceResourceResolver = null;
            try {
                serviceResourceResolver = RenditionMetadataListenerService.this.resourceResolverFactory.getServiceResourceResolver(Map.of("sling.service.subservice", RenditionMetadataListenerService.SERVICEUSER_SUBSERVICE));
                Resource assetResource = serviceResourceResolver.getResource(this.assetPath);
                if (assetResource == null) {
                    log.debug("Unable to read asset at {} with user {}", (Object)this.assetPath, (Object)serviceResourceResolver.getUserID());
                    return;
                }
                if (this.eventType == DamEvent.Type.RENDITION_UPDATED) {
                    this.renditionAddedOrUpdated(serviceResourceResolver);
                } else if (this.eventType == DamEvent.Type.RENDITION_REMOVED) {
                    this.renditionRemoved(serviceResourceResolver);
                }
            }
            catch (PersistenceException ex) {
                ++this.retryCount;
                if (this.retryCount >= 3) {
                    log.error("Failed after {} attempts: {}", new Object[]{this.retryCount, ex.getMessage(), ex});
                } else {
                    log.debug("Failed {} attempt(s), retry: {}", new Object[]{this.retryCount, ex.getMessage(), ex});
                    RenditionMetadataListenerService.this.executorService.schedule(this, 5L, TimeUnit.SECONDS);
                }
            }
            catch (LoginException ex) {
                log.error("Missing service user mapping for 'io.wcm.handler.media:dam-rendition-metadata' - see https://wcm.io/handler/media/configuration.html", (Throwable)ex);
            }
            finally {
                lock.unlock();
                if (serviceResourceResolver != null) {
                    serviceResourceResolver.close();
                }
            }
        }

        private void renditionAddedOrUpdated(ResourceResolver resolver) throws PersistenceException {
            log.trace("Process rendition added/updated event: {}", (Object)this.renditionPath);
            RenditionMetadataGenerator generator = new RenditionMetadataGenerator(resolver, RenditionMetadataListenerService.this.assetStore);
            generator.renditionAddedOrUpdated(this.renditionPath);
        }

        private void renditionRemoved(ResourceResolver resolver) throws PersistenceException {
            log.trace("Process rendition removed event: {}", (Object)this.renditionPath);
            RenditionMetadataGenerator generator = new RenditionMetadataGenerator(resolver, RenditionMetadataListenerService.this.assetStore);
            generator.renditionRemoved(this.renditionPath);
        }
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Rendition Metadata Service", description="Extracts additional metadata like width and height for AEM asset renditions.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Switch to enable or disable this service.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Allowed run mode(s)", description="Run modes this service is allowed on. The service is disabled if the run mode does not match.")
        public String[] allowedRunMode() default {"author"};

        @AttributeDefinition(name="Thread pool size", description="Size of threads in pool that is used to process asset rendition events asynchronously. Setting it to 0 disables asynchronous processing completely (not recommended for production environments).")
        public int threadPoolSize() default 10;
    }
}

