/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.weboptimized;

import com.day.cq.dam.api.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import io.wcm.handler.mediasource.ngdm.impl.SeoNameSanitizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

final class ParameterMap {
    static final String PARAM_PATH = "path";
    static final String PARAM_SEO_NAME = "seoname";
    static final String PARAM_FORMAT = "format";
    static final String PARAM_PREFER_WEBP = "preferwebp";
    static final String PARAM_WIDTH = "width";
    static final String PARAM_CROP = "c";
    static final String PARAM_ROTATE = "r";
    static final String PARAM_QUALITY = "quality";
    private static final Set<String> SUPPORTED_FORMATS = Set.of("jpg", "png", "gif", "webp");

    private ParameterMap() {
    }

    @NotNull
    static Map<String, Object> build(@NotNull Asset asset, @NotNull WebOptimizedImageDeliveryParams params) {
        String path = asset.getPath();
        String seoName = FilenameUtils.getBaseName((String)asset.getName());
        String format = StringUtils.toRootLowerCase((String)FilenameUtils.getExtension((String)asset.getName()));
        if (!SUPPORTED_FORMATS.contains(format)) {
            format = "jpg";
        }
        Long width = params.getWidth();
        CropDimension cropDimension = params.getCropDimension();
        Integer rotation = params.getRotation();
        Integer quality = params.getQuality();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PARAM_PATH, path);
        map.put(PARAM_SEO_NAME, SeoNameSanitizer.sanitizeSeoName(seoName));
        map.put(PARAM_FORMAT, format);
        map.put(PARAM_PREFER_WEBP, "true");
        if (width != null) {
            map.put(PARAM_WIDTH, width.toString());
        }
        if (cropDimension != null) {
            map.put(PARAM_CROP, cropDimension.getCropStringWidthHeight());
        }
        if (rotation != null && rotation != 0) {
            map.put(PARAM_ROTATE, rotation.toString());
        }
        if (quality != null) {
            map.put(PARAM_QUALITY, quality.toString());
        }
        return map;
    }
}

