/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.weboptimized;

import com.adobe.cq.wcm.spi.AssetDelivery;
import com.day.cq.dam.api.Asset;
import io.wcm.handler.mediasource.dam.impl.weboptimized.ParameterMap;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryService;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.Map;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={WebOptimizedImageDeliveryService.class}, immediate=true)
@Designate(ocd=Config.class)
public class WebOptimizedImageDeliveryServiceImpl
implements WebOptimizedImageDeliveryService {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private AssetDelivery assetDelivery;
    private boolean enabled;

    @Activate
    private void activate(Config config) {
        this.enabled = config.enabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.assetDelivery != null;
    }

    @Override
    @Nullable
    public String getDeliveryUrl(@NotNull Asset asset, @NotNull WebOptimizedImageDeliveryParams params) {
        if (!this.isEnabled()) {
            return null;
        }
        Resource resource = (Resource)AdaptTo.notNull((Adaptable)asset, Resource.class);
        Map<String, Object> parameterMap = ParameterMap.build(asset, params);
        return this.assetDelivery.getDeliveryURL(resource, parameterMap);
    }

    @ObjectClassDefinition(name="wcm.io Web-Optimized Image Delivery Support", description="Support for Next Generation Dynamic Media Web-Optimized Image Delivery capabilites.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enable support for Web-Optimized Image Delivery (if available).")
        public boolean enabled() default true;
    }
}

