/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.inline;

import com.day.image.Layer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.format.impl.MediaFormatSupport;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.media.impl.ImageFileServletSelector;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.media.impl.JcrBinary;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.mediasource.inline.InlineAutoCropping;
import io.wcm.handler.mediasource.inline.InlineUriTemplate;
import io.wcm.handler.mediasource.ngdm.impl.MediaArgsDimension;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.caching.ModificationDate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InlineRendition
extends SlingAdaptable
implements Rendition {
    private final Adaptable adaptable;
    private final Resource resource;
    private final MediaArgs mediaArgs;
    private final MediaHandlerConfig mediaHandlerConfig;
    private final String fileName;
    private final String fileExtension;
    private final String originalFileExtension;
    private final Dimension imageDimension;
    private final Dimension maxImageDimension;
    private final String url;
    private CropDimension cropDimension;
    private final Integer rotation;
    private MediaFormat resolvedMediaFormat;
    private boolean fallback;
    private static final Dimension SCALING_NOT_POSSIBLE_DIMENSION = new Dimension(-1L, -1L);

    InlineRendition(Resource resource, Media media, MediaArgs mediaArgs, MediaHandlerConfig mediaHandlerConfig, String fileName, Adaptable adaptable) {
        this.resource = resource;
        this.mediaArgs = mediaArgs;
        this.mediaHandlerConfig = mediaHandlerConfig;
        this.adaptable = adaptable;
        this.rotation = media.getRotation();
        this.cropDimension = media.getCropDimension();
        this.originalFileExtension = FilenameUtils.getExtension((String)fileName);
        boolean isImage = MediaFileType.isImage(this.originalFileExtension);
        boolean isVectorImage = MediaFileType.isVectorImage(this.originalFileExtension);
        Dimension dimension = null;
        Dimension maxDimension = null;
        Dimension scaledDimension = null;
        String processedFileName = fileName;
        if (isImage) {
            List<Dimension> dimensionCandidates = this.getImageOrCroppedDimensions();
            for (int i = 0; i < dimensionCandidates.size(); ++i) {
                maxDimension = dimension = dimensionCandidates.get(i);
                if (isVectorImage && (this.rotation != null || this.cropDimension != null)) {
                    scaledDimension = SCALING_NOT_POSSIBLE_DIMENSION;
                } else {
                    scaledDimension = this.getScaledDimension(dimension);
                    if (scaledDimension != null && this.isValidScalingDimension(scaledDimension)) {
                        dimension = scaledDimension;
                        if (!isVectorImage) {
                            processedFileName = ImageFileServlet.getImageFileName(processedFileName, mediaArgs.getEnforceOutputFileExtension());
                        }
                    }
                }
                if (!this.isValidScalingDimension(scaledDimension)) continue;
                if (i <= 0) break;
                this.cropDimension = null;
                this.fallback = true;
                break;
            }
            if (!this.isValidScalingDimension(scaledDimension) && mediaArgs.isAutoCrop() && !isVectorImage && dimension != null) {
                InlineAutoCropping autoCropping = new InlineAutoCropping(dimension, mediaArgs);
                List<CropDimension> autoCropDimensions = autoCropping.calculateAutoCropDimensions();
                for (CropDimension autoCropDimension : autoCropDimensions) {
                    scaledDimension = this.getScaledDimension(autoCropDimension);
                    maxDimension = autoCropDimension;
                    if (scaledDimension == null) {
                        scaledDimension = autoCropDimension;
                    }
                    if (!this.isValidScalingDimension(scaledDimension)) continue;
                    dimension = scaledDimension;
                    this.cropDimension = autoCropDimension;
                    if (isVectorImage) break;
                    processedFileName = ImageFileServlet.getImageFileName(processedFileName, mediaArgs.getEnforceOutputFileExtension());
                    break;
                }
            }
        }
        this.fileName = processedFileName;
        this.fileExtension = FilenameUtils.getExtension((String)processedFileName);
        this.imageDimension = dimension;
        this.maxImageDimension = maxDimension;
        this.url = this.buildMediaUrl(scaledDimension);
        MediaFormat firstMediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (this.url != null && firstMediaFormat != null) {
            this.resolvedMediaFormat = firstMediaFormat;
        }
    }

    private boolean isValidScalingDimension(@Nullable Dimension dimension) {
        return dimension == null || !dimension.equals(SCALING_NOT_POSSIBLE_DIMENSION);
    }

    private List<Dimension> getImageOrCroppedDimensions() {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        Dimension originalDimension = this.getImageDimension();
        if (originalDimension != null) {
            if (this.cropDimension != null) {
                dimensions.add(this.cropDimension);
            }
            dimensions.add(originalDimension);
        }
        return dimensions;
    }

    private Dimension getImageDimension() {
        Dimension dimension = null;
        Layer layer = (Layer)this.resource.adaptTo(Layer.class);
        if (layer != null) {
            dimension = new Dimension(layer.getWidth(), layer.getHeight());
        }
        return dimension;
    }

    @Nullable
    private Dimension getScaledDimension(@NotNull Dimension originalDimension) {
        boolean scaleHeight;
        Dimension requestedDimension = MediaArgsDimension.getRequestedDimension(this.mediaArgs);
        double requestedRatio = MediaArgsDimension.getRequestedRatio(this.mediaArgs);
        double imageRatio = Ratio.get(originalDimension);
        if (requestedRatio > 0.0 && !Ratio.matches(requestedRatio, imageRatio)) {
            return SCALING_NOT_POSSIBLE_DIMENSION;
        }
        boolean scaleWidth = requestedDimension.getWidth() > 0L && requestedDimension.getWidth() != originalDimension.getWidth();
        boolean bl = scaleHeight = requestedDimension.getHeight() > 0L && requestedDimension.getHeight() != originalDimension.getHeight();
        if (scaleWidth || scaleHeight) {
            long requestedWidth = requestedDimension.getWidth();
            long requestedHeight = requestedDimension.getHeight();
            if (requestedWidth == 0L && requestedHeight > 0L) {
                requestedWidth = Math.round((double)requestedHeight * imageRatio);
            } else if (requestedWidth > 0L && requestedHeight == 0L) {
                requestedHeight = Math.round((double)requestedWidth / imageRatio);
            }
            requestedRatio = Ratio.get(requestedWidth, requestedHeight);
            if (!Ratio.matches(imageRatio, requestedRatio) || originalDimension.getWidth() < requestedWidth || originalDimension.getHeight() < requestedHeight) {
                return SCALING_NOT_POSSIBLE_DIMENSION;
            }
            return new Dimension(requestedWidth, requestedHeight);
        }
        return null;
    }

    private String buildMediaUrl(Dimension scaledDimension) {
        if (!this.isMatchingFileExtension()) {
            return null;
        }
        if (scaledDimension != null) {
            if (scaledDimension.equals(SCALING_NOT_POSSIBLE_DIMENSION)) {
                return null;
            }
            return this.buildScaledMediaUrl(scaledDimension, this.cropDimension);
        }
        if (this.cropDimension != null || this.rotation != null) {
            return this.buildScaledMediaUrl(this.cropDimension != null ? this.cropDimension : this.imageDimension, this.cropDimension);
        }
        if (this.mediaArgs.isContentDispositionAttachment()) {
            return this.buildDownloadMediaUrl();
        }
        if (MediaFileType.isBrowserImage(this.getFileExtension()) || !MediaFileType.isImage(this.getFileExtension())) {
            if (this.enforceVirtualRendition()) {
                return this.buildScaledMediaUrl(this.imageDimension, null);
            }
            return this.buildNativeMediaUrl();
        }
        return this.buildScaledMediaUrl(this.imageDimension, null);
    }

    private boolean enforceVirtualRendition() {
        if (MediaFileType.isImage(this.getFileExtension()) && !MediaFileType.isVectorImage(this.getFileExtension())) {
            if (this.mediaHandlerConfig.enforceVirtualRenditions()) {
                return true;
            }
            if (this.mediaArgs.getEnforceOutputFileExtension() != null) {
                return !StringUtils.equalsIgnoreCase((CharSequence)this.getFileExtension(), (CharSequence)this.mediaArgs.getEnforceOutputFileExtension());
            }
        }
        return false;
    }

    private String buildNativeMediaUrl() {
        Object path = null;
        Resource parentResource = this.resource.getParent();
        path = parentResource != null && JcrBinary.isNtFile(parentResource) ? (StringUtils.equals((CharSequence)parentResource.getName(), (CharSequence)this.getFileName()) ? parentResource.getPath() : parentResource.getPath() + "./" + this.getFileName()) : this.resource.getPath() + "./" + this.getFileName();
        UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)this.adaptable, UrlHandler.class);
        return urlHandler.get((String)path).urlMode(this.mediaArgs.getUrlMode()).buildExternalResourceUrl(this.resource);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String buildScaledMediaUrl(@NotNull Dimension dimension, @Nullable CropDimension mediaUrlCropDimension) {
        if (this.isVectorImage()) {
            return this.buildNativeMediaUrl();
        }
        String resourcePath = this.resource.getPath();
        Resource parentResource = this.resource.getParent();
        if (parentResource != null && JcrBinary.isNtFile(parentResource)) {
            resourcePath = parentResource.getPath();
        }
        String path = resourcePath + "." + ImageFileServletSelector.build(dimension.getWidth(), dimension.getHeight(), mediaUrlCropDimension, this.rotation, this.mediaArgs.getImageQualityPercentage(), this.mediaArgs.isContentDispositionAttachment()) + ".file/" + ImageFileServlet.getImageFileName(this.getFileName(), this.mediaArgs.getEnforceOutputFileExtension());
        UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)this.adaptable, UrlHandler.class);
        return urlHandler.get(path).urlMode(this.mediaArgs.getUrlMode()).buildExternalResourceUrl(this.resource);
    }

    private String buildDownloadMediaUrl() {
        String resourcePath = this.resource.getPath();
        Resource parentResource = this.resource.getParent();
        if (parentResource != null && JcrBinary.isNtFile(parentResource)) {
            resourcePath = parentResource.getPath();
        }
        String path = resourcePath + ".media_file.download_attachment.file/" + this.getFileName();
        UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)this.adaptable, UrlHandler.class);
        return urlHandler.get(path).urlMode(this.mediaArgs.getUrlMode()).buildExternalResourceUrl(this.resource);
    }

    private boolean isMatchingFileExtension() {
        String[] extensions = MediaFormatSupport.getRequestedFileExtensions(this.mediaArgs);
        if (extensions == null) {
            return false;
        }
        if (extensions.length == 0) {
            return true;
        }
        for (String extension : extensions) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)extension, (CharSequence)this.originalFileExtension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getFileName() {
        if (this.url != null) {
            return FilenameUtils.getName((String)this.url);
        }
        return this.fileName;
    }

    @Override
    public String getFileExtension() {
        if (this.url != null) {
            return FilenameUtils.getExtension((String)this.url);
        }
        return StringUtils.defaultString((String)this.fileExtension, (String)this.originalFileExtension);
    }

    @Override
    public long getFileSize() {
        Node node = (Node)this.resource.adaptTo(Node.class);
        if (node != null) {
            try {
                Property data = node.getProperty("jcr:data");
                return data.getBinary().getSize();
            }
            catch (RepositoryException ex) {
                throw new RuntimeException("Unable to detect binary file size for " + this.resource.getPath(), ex);
            }
        }
        try {
            InputStream is = (InputStream)this.resource.getValueMap().get("jcr:data", InputStream.class);
            return IOUtils.toByteArray((InputStream)is).length;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to detect binary file size for " + this.resource.getPath(), ex);
        }
    }

    @Override
    public String getMimeType() {
        return JcrBinary.getMimeType(this.resource);
    }

    @Override
    public Date getModificationDate() {
        return ModificationDate.get((Resource)this.resource);
    }

    @Override
    public MediaFormat getMediaFormat() {
        return this.resolvedMediaFormat;
    }

    @Override
    public ValueMap getProperties() {
        return this.resource.getValueMap();
    }

    @Override
    public boolean isImage() {
        return MediaFileType.isImage(this.getFileExtension());
    }

    @Override
    public boolean isBrowserImage() {
        return MediaFileType.isBrowserImage(this.getFileExtension());
    }

    @Override
    public boolean isVectorImage() {
        return MediaFileType.isVectorImage(this.getFileExtension());
    }

    @Override
    public boolean isDownload() {
        return !this.isImage();
    }

    @Override
    public long getWidth() {
        if (this.imageDimension != null) {
            return ImageTransformation.rotateMapDimension(this.imageDimension, this.rotation).getWidth();
        }
        return 0L;
    }

    @Override
    public long getHeight() {
        if (this.imageDimension != null) {
            return ImageTransformation.rotateMapDimension(this.imageDimension, this.rotation).getHeight();
        }
        return 0L;
    }

    @Override
    public boolean isFallback() {
        return this.fallback;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        if (type == UriTemplateType.CROP_CENTER) {
            throw new IllegalArgumentException("CROP_CENTER not supported for rendition URI templates.");
        }
        if (!this.isImage() || this.isVectorImage()) {
            throw new UnsupportedOperationException("Unable to build URI template for " + this.resource.getPath());
        }
        if (this.maxImageDimension == null) {
            throw new IllegalStateException("Unable to detect dimension for inline image: " + this.resource.getPath());
        }
        Dimension dimension = ImageTransformation.rotateMapDimension(this.maxImageDimension, this.rotation);
        return new InlineUriTemplate(type, dimension, this.resource, this.fileName, this.cropDimension, this.rotation, this.mediaArgs, this.adaptable);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == Layer.class && this.isImage()) {
            return (AdapterType)this.getLayer();
        }
        if (type == InputStream.class) {
            return (AdapterType)this.resource.adaptTo(InputStream.class);
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Layer getLayer() {
        Layer layer = (Layer)this.resource.adaptTo(Layer.class);
        if (layer != null) {
            if (this.cropDimension != null) {
                layer.crop(this.cropDimension.getRectangle());
            }
            if (this.rotation != null) {
                layer.rotate((double)this.rotation.intValue());
            }
            long width = this.getWidth();
            long height = this.getHeight();
            if (width <= (long)layer.getWidth() && height <= (long)layer.getHeight()) {
                layer.resize((int)width, (int)height);
            }
        }
        return layer;
    }

    public String toString() {
        return Objects.toString(this.url, "#invalid");
    }
}

