/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import io.wcm.handler.media.Asset;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaRendition;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaUriTemplate;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NextGenDynamicMediaAsset
implements Asset {
    private final NextGenDynamicMediaContext context;

    NextGenDynamicMediaAsset(@NotNull NextGenDynamicMediaContext context) {
        this.context = context;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.context.getReference().getFileName();
    }

    @Override
    @Nullable
    public String getAltText() {
        if (this.context.getDefaultMediaArgs().isDecorative()) {
            return "";
        }
        return this.context.getDefaultMediaArgs().getAltText();
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.context.getReference().toReference();
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return ValueMap.EMPTY;
    }

    @Override
    @Nullable
    public Rendition getDefaultRendition() {
        return this.getRendition(this.context.getDefaultMediaArgs());
    }

    @Override
    @Nullable
    public Rendition getRendition(@NotNull MediaArgs mediaArgs) {
        NextGenDynamicMediaRendition rendition = new NextGenDynamicMediaRendition(this.context, mediaArgs);
        if (StringUtils.isEmpty((CharSequence)rendition.getUrl())) {
            rendition = null;
        }
        return rendition;
    }

    @Override
    @Nullable
    public Rendition getImageRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isImage()) {
            return rendition;
        }
        return null;
    }

    @Override
    @Nullable
    public Rendition getDownloadRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isDownload()) {
            return rendition;
        }
        return null;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        if (type == UriTemplateType.SCALE_HEIGHT) {
            throw new IllegalArgumentException("URI template type not supported: " + type);
        }
        return new NextGenDynamicMediaUriTemplate(this.context, type);
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> arg0) {
        return null;
    }
}

