/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditConfig;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaAsset;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import io.wcm.sling.models.annotations.AemObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class NextGenDynamicMediaMediaSource
extends MediaSource {
    @NotNull
    public static final String ID = "nextGenDynamicMedia";
    @Self
    private Adaptable adaptable;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private NextGenDynamicMediaConfigService nextGenDynamicMediaConfig;
    @OSGiService
    private MimeTypeService mimeTypeService;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private WCMMode wcmMode;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ComponentContext componentContext;

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public boolean accepts(@Nullable String mediaRef) {
        return this.isNextGenDynamicMediaEnabled() && NextGenDynamicMediaReference.isReference(mediaRef);
    }

    private boolean isNextGenDynamicMediaEnabled() {
        return this.nextGenDynamicMediaConfig != null && this.nextGenDynamicMediaConfig.enabled();
    }

    @Override
    @Nullable
    public String getPrimaryMediaRefProperty() {
        return this.mediaHandlerConfig.getMediaRefProperty();
    }

    @Override
    @NotNull
    public Media resolveMedia(@NotNull Media media) {
        String mediaRef = this.getMediaRef(media.getMediaRequest(), this.mediaHandlerConfig);
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        NextGenDynamicMediaReference reference = NextGenDynamicMediaReference.fromReference(mediaRef);
        if (reference == null || !this.isNextGenDynamicMediaEnabled()) {
            if (StringUtils.isEmpty((CharSequence)mediaRef)) {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_MISSING);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_INVALID);
            }
            return media;
        }
        Resource referencedResource = media.getMediaRequest().getResource();
        if (referencedResource != null) {
            this.updateMediaArgsFromResource(mediaArgs, referencedResource, this.mediaHandlerConfig);
        }
        NextGenDynamicMediaContext context = new NextGenDynamicMediaContext(reference, media, mediaArgs, this.nextGenDynamicMediaConfig, this.mediaHandlerConfig, this.mimeTypeService);
        NextGenDynamicMediaAsset asset = new NextGenDynamicMediaAsset(context);
        media.setAsset(asset);
        boolean renditionsResolved = this.resolveRenditions(media, asset, mediaArgs);
        if (!renditionsResolved) {
            if (media.getRenditions().isEmpty()) {
                media.setMediaInvalidReason(MediaInvalidReason.NO_MATCHING_RENDITION);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.NOT_ENOUGH_MATCHING_RENDITIONS);
            }
        }
        return media;
    }

    @Override
    public void enableMediaDrop(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
        if (this.wcmMode == WCMMode.DISABLED || this.wcmMode == null) {
            return;
        }
        if (this.componentContext != null && this.componentContext.getEditContext() != null) {
            EditConfig editConfig;
            if (MediaMarkupBuilderUtil.canApplyDragDropSupport(mediaRequest, this.componentContext)) {
                element.addCssClass("cq-dd-image");
            }
            if ((editConfig = this.componentContext.getEditContext().getEditConfig()) != null) {
                editConfig.setInplaceEditingConfig(null);
            }
        }
    }
}

