/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaUriTemplate;
import io.wcm.handler.mediasource.ngdm.impl.ImageQualityPercentage;
import io.wcm.handler.mediasource.ngdm.impl.MediaArgsDimension;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageDeliveryParams;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaUrlBuilder;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NextGenDynamicMediaRendition
implements Rendition {
    private final NextGenDynamicMediaContext context;
    private final NextGenDynamicMediaReference reference;
    private final MediaArgs mediaArgs;
    private final String url;
    private MediaFormat resolvedMediaFormat;
    private long width;
    private long height;

    NextGenDynamicMediaRendition(@NotNull NextGenDynamicMediaContext context, @NotNull MediaArgs mediaArgs) {
        Dimension ratioDimension;
        double ratio;
        this.context = context;
        this.reference = context.getReference();
        this.mediaArgs = mediaArgs;
        this.width = mediaArgs.getFixedWidth();
        this.height = mediaArgs.getFixedHeight();
        MediaFormat firstMediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (firstMediaFormat != null) {
            this.resolvedMediaFormat = firstMediaFormat;
            if (this.width == 0L) {
                this.width = firstMediaFormat.getEffectiveMinWidth();
            }
        }
        if (this.width > 0L && (ratio = MediaArgsDimension.getRequestedRatio(mediaArgs)) > 0.0) {
            this.height = Math.round((double)this.width / ratio);
        }
        NextGenDynamicMediaImageDeliveryParams params = new NextGenDynamicMediaImageDeliveryParams().rotation(context.getMedia().getRotation()).quality(ImageQualityPercentage.getAsInteger(mediaArgs, context.getMediaHandlerConfig()));
        if (this.width > 0L) {
            params.width(this.width);
        }
        if ((ratioDimension = MediaArgsDimension.getRequestedRatioAsWidthHeight(mediaArgs)) != null) {
            params.cropSmartRatio(ratioDimension);
        }
        this.url = new NextGenDynamicMediaUrlBuilder(context).build(params);
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public String getPath() {
        return null;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.reference.getFileName();
    }

    @Override
    @Nullable
    public String getFileExtension() {
        String extension = this.mediaArgs.getEnforceOutputFileExtension();
        if (StringUtils.isEmpty((CharSequence)extension)) {
            extension = FilenameUtils.getExtension((String)this.reference.getFileName());
        }
        return extension;
    }

    @Override
    public long getFileSize() {
        return -1L;
    }

    @Override
    @Nullable
    public String getMimeType() {
        return this.context.getMimeTypeService().getMimeType(this.getFileExtension());
    }

    @Override
    @Nullable
    public MediaFormat getMediaFormat() {
        return this.resolvedMediaFormat;
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return ValueMap.EMPTY;
    }

    @Override
    public boolean isImage() {
        return MediaFileType.isImage(this.getFileExtension());
    }

    @Override
    public boolean isBrowserImage() {
        return MediaFileType.isBrowserImage(this.getFileExtension());
    }

    @Override
    public boolean isVectorImage() {
        return MediaFileType.isVectorImage(this.getFileExtension());
    }

    @Override
    public boolean isDownload() {
        return !this.isImage();
    }

    @Override
    public long getWidth() {
        return this.width;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public Date getModificationDate() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        return new NextGenDynamicMediaUriTemplate(this.context, type);
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> arg0) {
        return null;
    }

    public String toString() {
        return Objects.toString(this.url, "#invalid");
    }
}

